/**
 * Copyright Cao ( http://wonderfl.net/user/Cao )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7MYn
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.media.*;

    [SWF(width="500",height="400",backgroundColor="#ffffff")]
    public class Skin extends Sprite {
//        [Embed(source="jo_howks.jpg")]
        private var myImage:Class;
        private var bitmap:Bitmap;
        private var bmd:BitmapData;
        private var video:Video;
        private var camera:Camera = Camera.getCamera();
        private var gtr:Number;        // 下限
        private var less:Number;       // 上限
        
        public function Skin() {
            var camera:Camera = Camera.getCamera();
            
            video = new Video(camera.width,camera.height);
            video.attachCamera(camera);
            
            bmd = new BitmapData(camera.width, camera.height, false,0xffffff);
            var bitmap:DisplayObject = addChild(new Bitmap(bmd));
            
        }

        public function detect(g:Number, ls:Number):void{
            gtr = g;
            less = ls;

            addEventListener(Event.ENTER_FRAME,loop);
        }
        
        private function loop(e:Event):void{
            bmd.draw(video);
                                    
            for(var y:int = 0 ; y < camera.height; y++){
                for(var x:int = 0 ; x < camera.width; x++){
                    var pixel:Number = bmd.getPixel(x,y);
                    var hsv:Object = rgb2hsv((pixel&0xff0000) >> 16,
                            (pixel & 0xff00) >> 8, (pixel & 0xff));
                    if(hsv.h > gtr && hsv.h < less)
                        bmd.setPixel(x,y, 0xff0000);   // 範囲内なら赤色に変える
                }
            }
        }
        
        // RGBをHSVに変換
        private function rgb2hsv(r:int, g:int, b:int):Object{
            var hsv:Object = new Object();

            hsv.h = hsv.s = hsv.v = 0.0;
            var cmax:Number = Math.max(r,Math.max(g,b));
            var cmin:Number = Math.min(r,Math.min(g,b));
            hsv.v = cmax;
            var c:Number = cmax - cmin;
            if (cmax == 0.0) hsv.s = 0.0; else hsv.s = c/cmax;
            if (hsv.s != 0.0){
                if (r == cmax)
                {
                    hsv.h = (g - b)/c;
                }else if (g == cmax) {
                    hsv.h = 2 + (b - r)/c;
                }else{
                    if (b == cmax) hsv.h = 4 + ( r - g)/c;
                }
                hsv.h *= 60.0;
                if (hsv.h < 0.0) hsv.h += 360.0;
            }

            return hsv;
        }
    }
}