/**
 * Copyright sugyan ( http://wonderfl.net/user/sugyan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7MMr
 */

// forked from sugyan's forked from: Perfect Shuffle Visualization
// forked from nitoyon's Perfect Shuffle Visualization
//------------------------------------------------------
// Perfect Shuffle Visualization
//------------------------------------------------------
// How many times does it requires for 15 cards to 
// go back to where one started?
//
// inspired by:
// http://d.hatena.ne.jp/nishiohirokazu/20100107/1262835414

// キーボードの上下で数を変更できるようにした
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.geom.Point;
    import flash.text.TextField;

    [SWF(width="465",height="465",backgroundColor="0x000000")]
    public class PerfectShuffle extends Sprite {
        private var num:int = 30;
        private var text:TextField = new TextField();
        private var sprite1:LinesSprite = new LinesSprite(num);
        private var sprite2:LinesSprite = new LinesSprite(num);

        public function PerfectShuffle() {
            stage.scaleMode = "noScale";
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();

            text.text = "n = " + num;
            text.textColor = 0xFFFFFF;
            stage.addChild(text);

            sprite1.y = 15.0;
            sprite2.y = 15.0;
            sprite2.next(1);
            sprite2.x = WIDTH;
            addChild(sprite1);
            addChild(sprite2);

            stage.addEventListener(Event.ENTER_FRAME, function ():void {
                    x -= 10;
                    // 左に見切れている方を右に移動
                    if (sprite1.localToGlobal(new Point).x < -WIDTH) {
                        sprite1.next(2);
                        sprite1.x += WIDTH * 2;
                    }
                    if (sprite2.localToGlobal(new Point).x < -WIDTH) {
                        sprite2.next(2);
                        sprite2.x += WIDTH * 2;
                    }
                }
            );
            stage.addEventListener(KeyboardEvent.KEY_DOWN, function (event:KeyboardEvent):void {
            	        // キーボード上下で線の本数を変更
                    if (event.keyCode == 38 || event.keyCode == 40) {
                        num += 2 * (39 - event.keyCode);
                        text.text = "n = " + num;
                        sprite1.setNum(num);
                        sprite2.setNum(num);
                        if (sprite1.x > sprite2.x) {
                            sprite1.next(1);
                        } else {
                            sprite2.next(1);
                        }
                    }
                }
            );
        }

        private function draw():void {
            for (var i:int = 0; i < numChildren; i++) {
            }
        }
    }
}


const WIDTH:Number = 465;
const HEIGHT:Number = 450;

import flash.display.Sprite;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class LinesSprite extends Sprite {

    private var indexes:Array = new Array();

    public function LinesSprite(num:int) {
        for (var i:int = 0; i < num; i++) {
            indexes[i] = i;
        }
        filters = [new BlurFilter()];
        draw();
    }

    // num個先の状態を描画する
    public function next(num:int):void {
        for (var i:int = 0; i < num; i++) {
            var tempArray:Array = indexes.slice();
            for (var j:int = 0; j < indexes.length; j++) {
                indexes[getNextIndex(j)] = tempArray[j];
            }
        }
        draw();
    }

    // 線の本数を変更、描画しなおす
    public function setNum(num:int):void {
        indexes.splice(0, indexes.length);
        for (var i:int = 0; i < num; i++) {
            indexes[i] = i;
        }
        draw();
    }

    private function draw():void {
        graphics.clear();
        var num:uint = indexes.length;
        for (var i:uint = 0; i < num; i++) {
            graphics.lineStyle(4, new ColorHSV(indexes[i] * 270.0 / num, .7).value, .7);
            graphics.moveTo(0.0, i * HEIGHT / num);
            graphics.lineTo(WIDTH, getNextIndex(i) * HEIGHT / num);
        }
    }

    private function getNextIndex(n:int):int {
        var length:uint = indexes.length;
        if (n < length / 2) {
            return n * 2 + 1;
        } else {
            return (n - length / 2) * 2;
        }
    }
}
