/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7LKz
 */

// forked from bkzen's [Stage3D] wireframe
// forked from civet's Stage3D Detection
package
{
    import flash.display.*;
    import flash.display3D.*;
    
    [SWF(width="465", height="465", frameRate="60")]
    
    public class FP11Test extends Sprite
    {
        private var _holder:*;
        private var sc: BitmapData　 = 　new BitmapData(465, 　465, 　false);
        
        public function FP11Test()
        {
            //Wonderfl.disable_capture();
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            var detection:Stage3DDetection = new Stage3DDetection(stage);
            detection.callback = onCreate;
            Wonderfl.disable_capture();
            //addChild(new Bitmap(sc));
        }
        
        private function onCreate(stage3D:Stage3D):void
        {    
            _holder = new Context3DExample(stage, stage3D, sc);
        }
    }
}


import flash.display.Stage;
import flash.display.Stage3D;
import flash.display3D.Context3D;
import flash.display3D.Context3DRenderMode;
import flash.events.ErrorEvent;
import flash.events.Event;
import flash.system.Capabilities;
import flash.system.System;
import flash.text.TextField;
import flash.text.TextFormat;

class Stage3DDetection
{
    private var output:TextField;
    
    public function Stage3DDetection(stage:Stage)
    {        
        output = new TextField();
        output.defaultTextFormat = new TextFormat("Tahoma", 12 ,0xffffff);
        output.width = stage.stageWidth;
        output.height = 60;
        output.text = "";
        stage.addChild(output);
        
        var version:String = Capabilities.version + " (" + Capabilities.playerType + ")";
        var stage3DAvailable:Boolean = stage.hasOwnProperty("stage3Ds");
        
        output.appendText("Player version: " + version + "\n");
        
        if(stage3DAvailable) {
            var stage3D:Stage3D = stage.stage3Ds[0];
            stage3D.addEventListener(Event.CONTEXT3D_CREATE, onContext3DCreate);
            stage3D.addEventListener(ErrorEvent.ERROR, onStage3DError);
            stage3D.requestContext3D(Context3DRenderMode.AUTO);
        }
    }
    
    private function onStage3DError(event:ErrorEvent):void
    {
        output.appendText("Context3D available: false" + "\n");
    }
    
    private function onContext3DCreate(event:Event):void
    {
        var stage3D:Stage3D = event.currentTarget as Stage3D;
        var context3D:Context3D = stage3D.context3D;
        var isHardwareAccelerated:Boolean = context3D.driverInfo.toLowerCase().indexOf("software") == -1;
                    
        output.appendText("Render mode: " + context3D.driverInfo + "\n");
        output.appendText("Hardware accelerated: " + isHardwareAccelerated + "\n");
        
        if (callback != null) callback(stage3D);
        context3D.enableErrorChecking = true;
    }
    
    public var callback:Function;
}


import com.adobe.utils.AGALMiniAssembler;
import com.adobe.utils.PerspectiveMatrix3D;

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.display.Stage;
import flash.display.Stage3D;
import flash.display.StageAlign;
import flash.display.StageScaleMode;
import flash.display3D.Context3D;
import flash.display3D.Context3DProgramType;
import flash.display3D.Context3DRenderMode;
import flash.display3D.Context3DTriangleFace;
import flash.display3D.Context3DVertexBufferFormat;
import flash.display3D.IndexBuffer3D;
import flash.display3D.Program3D;
import flash.display3D.VertexBuffer3D;
import flash.events.ErrorEvent;
import flash.events.Event;
import flash.geom.Matrix3D;
import flash.geom.Vector3D;

class Context3DExample
{
    public var viewWidth:Number = 640;
    public var viewHeight:Number = 480;
    public var zNear:Number = 1;
    public var zFar:Number = 500;
    public var fov:Number = 90;
    
    private var stage:Stage;
    private var stage3D:Stage3D;
    private var renderContext:Context3D;
    private var indexList:IndexBuffer3D;
    private var vertexes:VertexBuffer3D;
    
    private var projection:PerspectiveMatrix3D = new PerspectiveMatrix3D();
    private var model:Matrix3D = new Matrix3D();
    private var view:Matrix3D = new Matrix3D();
    private var finalTransform:Matrix3D = new Matrix3D();
    
    //For rotating the cube
    private const pivot:Vector3D = new Vector3D();
        
    private const VERTEX_SHADER: String =
        "m44 op, va0, vc0\n" + // 4x4 matrix transform
        "mov v0, va1";         // v0 = va1
        
    /*
        "m44 op, va0, vc0    \n" +    // 4x4 matrix transform 
        "mov v0, va1"; //copy color to varying variable v0
    */
    private const FRAGMENT_SHADER: String = 
        "add ft0.x, v0.x,     v0.y     \n" + 
        "add ft0.y, v0.y,     v0.z     \n" + 
        "add ft0.z, v0.z,     v0.w     \n" + 
        "add ft0.w, v0.w,     v0.x     \n" + 
        "sub ft0,   ft0,      fc1.xxxx \n" + 
        "slt ft0,   ft0,      fc1.yyyy \n" + 
        "mul ft0.x, ft0.x,    ft0.y    \n" + 
        "mul ft0.x, ft0.x,    ft0.z    \n" + 
        "mul ft0.x, ft0.x,    ft0.w    \n" + 
        "sub ft0.x, fc1.x,    ft0.x    \n" + 
        "kil ft0.x \n" + 
        "mov oc, fc0";
    /*
        "mov oc, v0"; //Set the output color to the value interpolated from the three triangle vertices 
    */
    
    private var vertexAssembly:AGALMiniAssembler = new AGALMiniAssembler();
    private var fragmentAssembly:AGALMiniAssembler = new AGALMiniAssembler();
    private var programPair:Program3D;
    private var _sc: BitmapData;
    
    public function Context3DExample(stage:Stage, stage3D:Stage3D, sc: BitmapData = null)
    {
        _sc = sc;
        this.stage = stage;
        this.stage3D = stage3D;
        this.viewWidth = stage.stageWidth;
        this.viewHeight = stage.stageHeight;
                
        //Add event listener before requesting the context
        //stage3D.addEventListener( Event.CONTEXT3D_CREATE, contextCreated );
        //stage3D.addEventListener( ErrorEvent.ERROR, contextCreationError );
        //stage3D.requestContext3D( Context3DRenderMode.AUTO );
                
        //Compile shaders
        vertexAssembly.assemble( Context3DProgramType.VERTEX, VERTEX_SHADER );
        fragmentAssembly.assemble( Context3DProgramType.FRAGMENT, FRAGMENT_SHADER );
        
        contextCreated();      
    }
    
    //Note, context3DCreate event can happen at any time, such as when the hardware resources are taken by another process
    private function contextCreated( event:Event=null ):void
    {
        renderContext = stage3D.context3D;
        setupScene();
    }
    
    private function setupScene():void
    {
        renderContext.enableErrorChecking = true; //Can slow rendering - only turn on when developing/testing
        renderContext.configureBackBuffer( viewWidth, viewHeight, 2, false );
        //renderContext.setCulling( Context3DTriangleFace.BACK );
        renderContext.setCulling( Context3DTriangleFace.NONE );
        
        //Create vertex index list for the triangles forming a cube
        var triangles:Vector.<uint> = Vector.<uint>( [ 
            2,1,0, //front face
            3,2,0,
            4,7,5, //bottom face
            7,6,5,
            8,11,9, //back face
            9,11,10,
            12,15,13, //top face
            13,15,14,
            16,19,17, //left face
            17,19,18,
            20,23,21, //right face
            21,23,22
        ] );
        indexList = renderContext.createIndexBuffer( triangles.length );
        indexList.uploadFromVector( triangles, 0, triangles.length );
        
        //Create vertexes - cube faces do not share vertexes
        const dataPerVertex:int = 7;
        var vertexData:Vector.<Number> = Vector.<Number>(
            [
                // x,y,z    r,g,b,a
                0,0,0, 1,0,0,0, //front face
                0,1,0, 0,1,0,0, 
                1,1,0, 0,0,1,0, 
                1,0,0, 0,0,0,1, 
                
                0,0,0, 1,0,0,0,//bottom face
                1,0,0, 0,1,0,0,
                1,0,1, 0,0,1,0,
                0,0,1, 0,0,0,1,
                
                0,0,1, 1,0,0,0,//back face
                1,0,1, 0,1,0,0,
                1,1,1, 0,0,1,0,
                0,1,1, 0,0,0,1,
                
                0,1,1, 1,0,0,0,//top face
                1,1,1, 0,1,0,0,
                1,1,0, 0,0,1,0,
                0,1,0, 0,0,0,1,
                
                0,1,1, 1,0,0,0,//left face
                0,1,0, 0,1,0,0,
                0,0,0, 0,0,1,0,
                0,0,1, 0,0,0,1,
                
                1,1,0, 1,0,0,0,//right face
                1,1,1, 0,1,0,0,
                1,0,1, 0,0,1,0,
                1,0,0, 0,0,0,1
            ]
        );
        vertexes = renderContext.createVertexBuffer( vertexData.length/dataPerVertex, dataPerVertex );
        vertexes.uploadFromVector( vertexData, 0, vertexData.length/dataPerVertex );
        
        //Identify vertex data inputs for vertex program
        renderContext.setVertexBufferAt( 0, vertexes, 0, Context3DVertexBufferFormat.FLOAT_3 ); //va0 is position
        renderContext.setVertexBufferAt( 1, vertexes, 3, Context3DVertexBufferFormat.FLOAT_4 ); //va1 is position2
        
        renderContext.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, Vector.<Number>([
            1, 1, 1, 1, // fc0 r,g,b,a
            1 - 0.01, 0, 0, 0 // fc1.x = 1 - line size, fc1.y = 0
        ]));
        
        //Upload programs to render context
        programPair = renderContext.createProgram();
        programPair.upload( vertexAssembly.agalcode, fragmentAssembly.agalcode );
        renderContext.setProgram( programPair );
        
        //Set up 3D transforms
        projection.perspectiveFieldOfViewRH( fov, viewWidth/viewHeight, zNear, zFar );            
        view.appendTranslation( 0, 0, -2 );    //Move view back
        model.appendTranslation( -.5, -.5, -.5 ); //center cube on origin
        stage.addEventListener( Event.ENTER_FRAME, render );
    }
    
    private function render( event:Event ):void
    {
        //Rotate model on each frame
        model.appendRotation( .5, Vector3D.Z_AXIS, pivot );
        model.appendRotation( .5, Vector3D.Y_AXIS, pivot );
        model.appendRotation( .5, Vector3D.X_AXIS, pivot );
        
        //Combine transforms
        finalTransform.identity();
        finalTransform.append( model );
        finalTransform.append( view );
        finalTransform.append( projection );
        
        //Pass the final transform to the vertex shader as program constant, vc0
        renderContext.setProgramConstantsFromMatrix( Context3DProgramType.VERTEX, 0, finalTransform, true );
        
        //Clear is required before drawTriangles on each frame
        renderContext.clear( 0,0,0,1 );
        
        //Draw the 12 triangles that make up the cube
        renderContext.drawTriangles( indexList, 0, 12 );
        
        //Show the frame
        //renderContext.drawToBitmapData(_sc);
        renderContext.present();
    }
    
    private function contextCreationError( error:ErrorEvent ):void
    {
        trace( error.errorID + ": " + error.text );
    }
}