/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7L2A
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.geom.Point;
 
	public class Main extends Sprite
	{
		private var vp:Point = new Point(stage.stageWidth / 2, stage.stageHeight / 2);
		private var data:Array = new Array();
		private var camera:Camera = new Camera();
		private var radian:Number = 0.01;
 
		public function Main()
		{
			for (var i:int = 0; i < 150; i++)
			{
				var ball:Ball = new Ball();
				ball.px = Math.random() * 300 - 150;
				ball.py = Math.random() * 300 - 150;
				ball.pz = Math.random() * 300;
				addChild(ball);
 
				data.push(ball);
			}
 
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			data.sortOn("pz", Array.NUMERIC | Array.DESCENDING);
 
			for (var i:int = 0; i < data.length; i++)
			{
				var ball:Ball = data[i];
				addChild(ball);
 
				ball.rotateX(radian);
				ball.rotateY(radian);
				ball.rotateZ(radian);
 
				var scale:Number = camera.getScale(ball.pz);
				ball.scaleX = ball.scaleY = scale;
 
				if (ball.pz > camera.z - camera.f)
				{
					ball.x = vp.x + (ball.px - camera.x) * scale;
					ball.y = vp.y + (ball.py - camera.y) * scale;
					ball.visible = true;
				}
				else
				{
					ball.visible = false;
				}
			}
		}
 
		private function onKeyDown(event:KeyboardEvent):void 
		{
			if (event.keyCode == 37) camera.x -= 10;
			if (event.keyCode == 39) camera.x += 10;
			if (event.keyCode == 38) camera.y -= 10;
			if (event.keyCode == 40) camera.y += 10;
 
			if (event.keyCode == 83) camera.z -= 10;
			if (event.keyCode == 87) camera.z += 10;
		}
	}
}
 
 
import flash.display.Sprite;
 
class Ball extends Sprite
{
	public var px:Number = 0;
	public var py:Number = 0;
	public var pz:Number = 0;
 
	public function Ball()
	{
		graphics.beginFill(int.MAX_VALUE * Math.random());
		graphics.drawCircle(0, 0, 3);
		graphics.endFill();
	}
 
	public function rotateX(radian:Number):void
	{
		var cos:Number = Math.cos(radian);
		var sin:Number = Math.sin(radian);
 
		var tempA:Number = this.py * cos - this.pz * sin;
		var tempB:Number = this.py * sin + this.pz * cos;
 
		this.py = tempA;
		this.pz = tempB;
	}
 
	public function rotateZ(radian:Number):void
	{
		var cos:Number = Math.cos(radian);
		var sin:Number = Math.sin(radian);
 
		var tempA:Number = this.px * cos - this.py * sin;
		var tempB:Number = this.px * sin + this.py * cos;
 
		this.px = tempA;
		this.py = tempB;
	}
 
	public function rotateY(radian:Number):void
	{
		var cos:Number = Math.cos(radian);
		var sin:Number = Math.sin(radian);
 
		var tempA:Number = this.px * cos - this.pz * sin;
		var tempB:Number = this.px * sin + this.pz * cos;
 
		this.px = tempA;
		this.pz = tempB;
	}
}
 
class Camera
{
	public var x:Number = 0;
	public var y:Number = -100;
	public var z:Number = 100;
	public var f:Number = 200;
 
	public function getScale(objZ:Number):Number
	{
		var scale:Number = f / (f + objZ - z);
		return (scale < 0) ? 0 : scale;
	}
}
