/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Jhu
 */

// forked from wh0's dripping spectrum
/*
multipart project 2
part 3 of, I don't know, like 5

Background:
All the cool kids make Flash spectrum analyzers. I want to
make one too. So yeah. Let's do that.

Task:
- learn how to use the sound API to get spectrum data
- make it drip...
- benchmark performance
*/

package {
    import net.hires.debug.Stats;
    import flash.display.Sprite;
    import flash.system.Security;
    import flash.media.Sound;
    import flash.net.URLRequest;
    import flash.media.SoundLoaderContext;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.utils.ByteArray;
    import flash.media.SoundMixer;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.display.BitmapData;
    public class Spectrum extends Sprite {
        
        private static const PROXY:String = 'http://5ivestar.org/proxy/';
        
        private const s:ByteArray = new ByteArray();
        private const r:Rectangle = new Rectangle(0, 0, 1, 1);
        private const c:ColorTransform = new ColorTransform(1, 1, 1, 1, -2, -2, -2, 0);
        private var d:BitmapData;
        private var drops:Vector.<Drop>;
        
        public function Spectrum() {
            Security.loadPolicyFile(PROXY + 'crossdomain.xml');
            var s:Sound = new Sound(new URLRequest(PROXY + 'http://scfire-dtc-aa06.stream.aol.com:80/stream/1035'), new SoundLoaderContext(1000, true));
            s.play();
            
            d = new BitmapData(256, 256, false, 0x000000);
            addChild(new Bitmap(d));
            
            drops = new Vector.<Drop>(256, true);
            for (var i:int = 0; i < 256; i++)
                drops[i] = new Drop();
            
            addEventListener(Event.ENTER_FRAME, comp);
            
            addChild(new Stats()).x = 256;
        }
        
        private function comp(e:Event):void {
            d.lock();
            d.colorTransform(d.rect, c);
            SoundMixer.computeSpectrum(s, true);
            s.position = 0;
            for (var x:int = 0; x < 256; x++) {
                var y:int = s.readFloat() * 128;
                r.x = x;
                r.height = y;
                d.fillRect(r, 0xffffff);
                if (y > drops[x].y) {
                    drops[x].y = y;
                    drops[x].v = 254;
                }
                if (drops[x].v > 0) {
                    d.setPixel(x, drops[x].y, Math.max(drops[x].color, d.getPixel(x, drops[x].y)));
                    drops[x].v -= 2;
                    if (drops[x].v <= 128)
                        drops[x].y = 0;
                    else if (Math.random() < 0.1)
                        drops[x].y++;
                }
            }
            d.unlock();
        }
        
    }
}

internal class Drop {
    
    public var y:int,  v:int;
    
    public function get color():uint {
        return v << 16 | v << 8 | v;
    }
    
}