/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7JaF
 */

package
{
    import net.hires.debug.*;
    import flash.display.*;
    import flash.events.*;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class Main extends Sprite
    {
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            Buffer.initContext(stage);
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Buffer
{
    public static var CANVAS :Stage;         /* the stage inherited from Main */  
    public static var OUTPUT :Output;        /* debug display text */ 
    public static var BACKGROUND :Background /* custom animated background, two alternating colors */ 
    public static var CANVAS_ARRAY :Array;   /* the array of (display objects) to be added */
    
    public static function initContext($canvas:Stage) :void
    {
        CANVAS = $canvas;
        OUTPUT = new Output("Animated Background Class (colorA, colorB)");
        BACKGROUND = new Background(0xCCCCCC, 0xAAAAAA);
        CANVAS_ARRAY = [BACKGROUND, OUTPUT];
        
        addChildren();
    }
    
    public static function addChildren() :void
    {
        for each (var $obj:DisplayObject in CANVAS_ARRAY)
        {
            CANVAS.addChild($obj);
        }
    }
}

class Background extends Sprite
{
    private var pathData :Array;
    private var colorA :uint;
    private var colorB :uint;
    
    public function Background($colorA:uint, $colorB:uint)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        pathData = [];
        colorA = $colorA;
        colorB = $colorB;
        
        for (var $:int = -3; $<15; $++)
        {
            var $pos :int = ($*31);
            var $pathPoints :Vector.<Number> = new Vector.<Number>(); //GraphicsPath demands Vector of 'Number'
                $pathPoints.push($pos,0, ($pos+31),0, ($pos+62),464, ($pos+31),464, $pos,0);
        
            pathData.push($pathPoints);
        }      
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        init();    

        addEventListener(Event.ENTER_FRAME, update);
    }
    
    public function init() :void
    {
        graphics.clear();
        
        for (var $:int = 0; $<pathData.length; $++)
        {
            var $fill :GraphicsSolidFill;
            
            ($ % 2 == 0) ? ($fill = new GraphicsSolidFill(colorA))
                         : ($fill = new GraphicsSolidFill(colorB));
            
            var $stroke :GraphicsStroke;
            
            var $pathCommands :Vector.<int> = new Vector.<int>(5, true);
                $pathCommands[0] = GraphicsPathCommand.MOVE_TO;
                $pathCommands[1] = GraphicsPathCommand.LINE_TO;
                $pathCommands[2] = GraphicsPathCommand.LINE_TO;
                $pathCommands[3] = GraphicsPathCommand.LINE_TO;
                $pathCommands[4] = GraphicsPathCommand.LINE_TO;
                
            var $path :GraphicsPath = new GraphicsPath($pathCommands, pathData[$]);
            var $data :Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
                $data.push($stroke, $fill, $path);
            
            graphics.drawGraphicsData($data);
        }
        
        graphics.lineStyle(1);
        graphics.beginFill(0, 0);
        graphics.drawRect(0, 0, 464, 464);
        graphics.endFill();
    }
    
    public function update($e:*) :void
    {
        for (var $outer:int = 0; $outer<pathData.length; $outer++)
        {
            for (var $inner:int = 0; $inner<10; $inner+=2) //iterates positions 0, 2, 4, 6, 8
            {
                if (pathData[$outer][0] > 495)
                {
                    var $pathPoints :Vector.<Number> = new Vector.<Number>(); //GraphicsPath demands Vector of 'Number'
                        $pathPoints.push(-62,0, -31,0, 0,464, -31,464, -62,0);
                    
                    pathData[$outer] = $pathPoints;
                }

                pathData[$outer][$inner]+=0.5;
            }
        }

        init();
    }
}

class Output extends TextField
{
    private var textFormat :TextFormat;
        
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 2, $y:Number = 1, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
            
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        init(); 
    }
        
    public function init() :void
    {
        x = _x;
        y = _y;
        text = _content;
            
        textFormat = new TextFormat(_font, null, 0);
        setTextFormat(textFormat);
    }   
        
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
        
    public function set font($:String) :void
    { _font = $; init() }
    public function set content($:String) :void
    { _content += ("\n> " + $); init() }
}