/**
 * Copyright NINECUBE ( http://wonderfl.net/user/NINECUBE )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7JYn
 */

package
{
    import flash.display.*;
    import flash.events.*;
    
    import org.papervision3d.view.BasicView;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.Lines3D;
    import org.papervision3d.materials.special.LineMaterial;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.cameras.CameraType;

    

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
    public class PV9x9 extends BasicView
    {
        private var pixels:Pixels;
        private var plane:Plane;
        private var rotx:Number = 0;
        private var roty:Number = 0; 
        
        private var movVal:uint = 450;

        // コンストラクタ
        public function PV9x9()
        {
            // もろもろの準備
            stage.quality=StageQuality.HIGH;
            //super(0, 0, true, true);
            super(0, 0, true, true, CameraType.FREE);
            //camera.z = -465;
            
            var line:LineMaterial = new LineMaterial(0xFFFFFF, .2);
            var lineX:Lines3D = new Lines3D(line);
            var lineY:Lines3D = new Lines3D(line);
            //var lineZ:Lines3D = new Lines3D(line);
            lineX.addNewLine(1, 0, 0, 0, movVal, 0, 0);
            lineY.addNewLine(1, 0, 0, 0, 0, movVal, 0);
            //lineZ.addNewLine(1, 0, 0, 0, 0, 0, -500);
            scene.addChild(lineX);
            scene.addChild(lineY);
            //scene.addChild(lineZ);
            
            //ちょっと移動
            lineX.x = lineX.y = lineY.x = lineY.y -= movVal * .5;
            
            //マテリアルの生成
            var material:WireframeMaterial = new WireframeMaterial(0xFFFFFF, .1);
            material.doubleSided = false;
            
           //Planeの生成
           var wh:uint =  movVal;
           var seg:uint = 8;
            for (var i:uint = 0; i < 1; i++)
            {
                plane = new Plane(material, wh, wh, seg, seg);
                plane.x = plane.y = wh * .5 - movVal * .5;
                plane.z = -wh / seg * i;
                scene.addChild(plane);
                var viewer:VertexNumberViewer = addChild(new VertexNumberViewer(plane, i + 1)) as VertexNumberViewer;
            }
            
            //camera.x = 0;
            //camera.y = 0;
            camera.focus = 500;
            camera.zoom = 2;
            camera.z = -camera.focus * camera.zoom - 500;
            
            startRendering();
            //singleRender();
            //addEventListener(Event.ENTER_FRAME, onFrame);
            
            //stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            //stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
            //stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
        }

        // エンターフレーム
        private function onFrame(e:Event):void
        {
            easePitch += (cameraPitch - easePitch) * 0.1;
            easeYaw += (cameraYaw - easeYaw) * 0.1;
            camera.x = 850 * Math.sin(easeYaw * Number3D.toRADIANS)-100;
            camera.z = 850 * Math.cos(easeYaw * Number3D.toRADIANS)+100;
            camera.y = 2 * easePitch + 50;
        }
        
        // ----------------------------------------------
        // Mouse Interactive
        // ----------------------------------------------
        
        private var isOribiting:Boolean;
        private var cameraPitch:Number = 230;
        private var cameraYaw:Number = 120;
        private var previousMouseX:Number;
        private var previousMouseY:Number;
        private var easePitch:Number = 100;
        private var easeYaw:Number = 180;
        
        private function mouseDown(event:MouseEvent):void {
            isOribiting = true;
            previousMouseX = event.stageX;
            previousMouseY = event.stageY;
            singleRender();
        }
 
        private function mouseUp(event:MouseEvent):void {
            isOribiting = false;
        }
 
        private function mouseMove(event:MouseEvent):void {
            var differenceX:Number = event.stageX - previousMouseX;
            var differenceY:Number = event.stageY - previousMouseY;
 
            if(isOribiting) {
                cameraPitch += differenceY * 0.25;
                cameraYaw += differenceX * 0.25;
                
                //cameraPitch = Math.max(5, Math.min(cameraPitch, 360));
 
                previousMouseX = event.stageX;
                previousMouseY = event.stageY;
            }
        }
    }
}


import flash.display.*;
import flash.events.Event;
import flash.text.*;
import org.papervision3d.core.effects.utils.BitmapClearMode;
import org.papervision3d.core.geom.Pixels;
import org.papervision3d.core.geom.renderables.*;
import org.papervision3d.objects.*;
import org.papervision3d.scenes.*;
import org.papervision3d.view.*;
import org.papervision3d.view.layer.BitmapEffectLayer;
/**
* 頂点の番号を表示させるクラスです。
* BasicViewに直接addChildして使います。sceneにaddChildするのではありません。
*/
class VertexNumberViewer extends Sprite
{
    
    private var pixels:Pixels;
    private var ary:Array;
    private var s:Scene3D;
    private var vp:Viewport3D;
    private var _obj:DisplayObject3D;
    private var verticesNum:uint;
    private var offsetX:Number;
    private var offsetY:Number;
    private var _baseNum:uint;
    
    /**
    * コンストラクタ。
    * @param obj 頂点番号を表示させる対象オブジェクト
    */
    public function VertexNumberViewer(obj:DisplayObject3D, baseNum:uint)
    {
        _obj = obj;
        _baseNum = baseNum;
        addEventListener(Event.ADDED_TO_STAGE, onAdd);
    }
    
    /*
    * テキストフィールドなどの生成を行います。
    * 親オブジェクトやステージの大きさを知るため、ADD_TO_STAGEイベントのリスナにしています
    * @param e
    */
    private function onAdd(e:Event):void {
        var bv:BasicView = this.parent as BasicView;
        s = bv.scene;
        vp = bv.viewport;
        
        
        var layer:BitmapEffectLayer = new BitmapEffectLayer(vp, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE, true);
        layer.clearBeforeRender = true;
        vp.containerSprite.addLayer(layer);
        
        //Pixels生成
        pixels = new Pixels(layer);
        s.addChild(pixels);
        
        verticesNum = _obj.geometry.vertices.length;//頂点数
        var p:Pixel3D;
        var vertex:Vertex3D;
        for (var v:int = 0; v < verticesNum; v++)
        {
            vertex = _obj.geometry.vertices[v];
            p = new Pixel3D(0x00000000, vertex.x, vertex.y, vertex.z);
            pixels.addPixel3D(p);
        }
        
        var fmt:TextFormat = new TextFormat();
        //fmt.font = "_ゴシック";//重い。
        fmt.size = 12;
        fmt.color = 0xB1016B;
        
        var fmt729:TextFormat = new TextFormat();
        //fmt.font = "_ゴシック";//重い。
        fmt729.size = 24;
        fmt729.color = 0xE3007F;
        
        //TextField生成
        ary=[];
        var tf:TextField;
        var numArr:Array = [1, 2, 3, 4, 5, 6, 7, 8, 9];
        var nn:uint;
        for (var i:int=0; i < verticesNum; i++)
        {
            nn = numArr[i % 9] * int(i / 9 + 1) * _baseNum;
            
            tf = new TextField();
            if (nn != 729) tf.defaultTextFormat = fmt;
            else tf.defaultTextFormat = fmt729;
            tf.selectable = false;
            tf.text = String(nn);
            //tf.autoSize = TextFieldAutoSize.RIGHT; //重い。
            addChild(tf);
            ary[i] = tf;
        }
        
        
        offsetX = stage.stageWidth >> 1;
        offsetY = stage.stageHeight >> 1;
        
        addEventListener(Event.ENTER_FRAME, redraw);
    }
    
    /**
    * テキストフィールドの位置を対象オブジェクトの座標と同期します。
    * とりあえずEnterFrameで回すようにしましたが、パフォーマンス上あんまりよくないかもしれないです
    * @param e
    */
    public function redraw(e:Event = null):void
    {
        //pixelsの変換
        pixels.rotationX = _obj.rotationX;
        pixels.rotationY = _obj.rotationY;
        pixels.rotationZ = _obj.rotationZ;
        pixels.x = _obj.x+4;
        pixels.y = _obj.y +22;
        pixels.z = _obj.z;
        

        var v3d:Vertex3DInstance;
        var i:int=0;
        for each (var _p:Pixel3D in pixels.pixels)
        {
            v3d = _p.vertex3D.vertex3DInstance;
            if (v3d.visible)
            {
                (ary[i] as TextField).x=v3d.x + offsetX;
                (ary[i] as TextField).y=v3d.y + offsetY;
                i++;
            }
        }
    }
    
    
}
