/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7JGL
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Shader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.ShaderFilter;
    import flash.geom.Point;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.ByteArray;

    public class WonderPixelate5 extends Sprite
    {
        public var loaderImage : Loader = new Loader;
        public var loaderShader : URLLoader = new URLLoader;
        public var bmp : Bitmap;
        public var shader : Shader = new Shader;
        public var seed : int = Math.floor(Math.random()*0xFFFF);
        public var offset : Array = [new Point, new Point];
        public var bmpdPerlin : BitmapData;
    
        
        public function WonderPixelate5(){
            graphics.beginFill(0x222222, 1);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            loaderImage.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLoaded);
            loaderImage.load(new URLRequest("http://www.bongiovi.tw/wonderfl/mood.jpg"), new LoaderContext(true));
        }
        
        
        private function imgLoaded(e:Event) : void {
            bmp = Bitmap(loaderImage.content);
            addChild(bmp).y = ( 465 - bmp.height ) * .5;
            loaderShader.addEventListener(Event.COMPLETE, shaderLoaded);
            loaderShader.dataFormat = URLLoaderDataFormat.BINARY;
            loaderShader.load(new URLRequest("http://www.bongiovi.tw/wonderfl/Pixelate5.pbj"));
        }
        
        
        private function shaderLoaded(e:Event) : void {
            shader.byteCode = ByteArray(loaderShader.data);
            bmpdPerlin = new BitmapData(bmp.width*.5, bmp.height*.5);
            addEventListener(Event.ENTER_FRAME, render);
        }
        
        
        public function render(e:Event) : void {
            const SPEED : int = 2;
            bmpdPerlin.perlinNoise(bmp.width*.5, bmp.height*.5, 3, seed, false, true, 1, false, offset);
            offset[0].x += SPEED;
            offset[1].y += SPEED;
            shader.data.range.value = [stage.mouseX / stage.stageWidth * 40 + 10];
            shader.data.radius.value = [stage.mouseY / stage.stageHeight * 40 + 10];
            
            shader.data.srcPerlin.input = bmpdPerlin;
            bmp.filters = [new ShaderFilter(shader)];
        }
    }
}



/*

<languageVersion : 1.0;>

kernel Pixelate
<   namespace : "bongiovi.tw";
    vendor : "bongiovi";
    version : 1;
    description : "Pixelate Effect";
>
{
    input image4 src;         
    input image4 srcPerlin;
    output pixel4 dst;

    parameter float range
    <
        minValue:1.0;
        maxValue:200.0;
        defaultValue:50.0;
    >;             
         
    
    parameter float offset0
    <
        minValue:0.0;
        maxValue:1.0;
        defaultValue:0.5;
    >;
    
    
    parameter float offset1
    <
        minValue:0.0;
        maxValue:1.0;
        defaultValue:0.5;
    >;                 
    
    
    parameter float radius
    <
        minValue:1.0;
        maxValue:1000.0;
        defaultValue:10.0;
    >;
    
    
    
    
    void
    evaluatePixel()
    {
        float2 pos = outCoord();        
        float2 grid = float2(range, range);
        
        float2 pos1 = floor(pos/grid + offset0);
        pos1 = pos1*grid - pos;
        float dist1 = pos1.x * pos1.x + pos1.y * pos1.y;
        
                                                        
        float2 base2 = grid*.5;
        float2 pos2 = floor((pos-base2)/grid + offset1);
        pos2 = pos2*grid + base2 - pos;
        float dist2 = pos2.x * pos2.x + pos2.y * pos2.y;

        float2 posFinal = (dist1 > dist2) ? pos2 : pos1;         
        posFinal = posFinal + pos;
        dst = sampleLinear(src, posFinal);        
        
        float4 perlin = sampleLinear(srcPerlin, posFinal*.5);
        if(distance(pos, posFinal) > radius * perlin.r) dst.a = 0.0;         
    }
}


*/
