/**
 * Copyright Zahurdias.Calimero ( http://wonderfl.net/user/Zahurdias.Calimero )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7JDQ
 */

package {
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    public class BasicAnimation extends Sprite
    {
        // ------- Constructor -------
        
        public function BasicAnimation()
        {
            _createChildren();
        }
        
        
        // ------- Child display objects -------
        
        private var _rect:Sprite;
        
        
        // ------- Private constants -------
        
        private const START:int = 100;
        private const END:int = 400;

        
        // ------- Private methods -------
        
        private function _createChildren():void 
        {
            _rect = new Sprite();
            _rect.graphics.beginFill(0xff0000, 1);
            _rect.graphics.drawRect(0, 0, 100, 100);
            _rect.graphics.endFill();
            _rect.x = START;
            addChild(_rect);
            _rect.addEventListener(MouseEvent.CLICK, _rect_click);
        }
        
        
        // ------- Event handling -------
        
        private function _rect_click(event:MouseEvent):void 
        {
            // right way (very basic):
            addEventListener(Event.ENTER_FRAME, _enterFrameBasic);
        }
        
        
        private function _enterFrameBasic(event:Event):void 
        {
            if (_rect.x < END)
            {
                _rect.x++;
            }
            else
            {
                removeEventListener(Event.ENTER_FRAME, _enterFrameBasic);
            }
        }
    }
}