/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7JDJ
 */

package 
{
	import flash.events.Event;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Sphere;
	
	import org.papervision3d.view.BasicView;
	
	[SWF(width=465,height=465,backgroundColor=0x000000)]
	public class Main extends BasicView
	{
		private const SPHERE_NUM:int = 300;
		private var rot:Number = 0;
		
		public function Main():void 
		{
			draw();
			startRendering();
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(event:Event):void 
		{
			var targetRot:Number = (mouseX / stage.stageWidth) * 360;
			rot += (targetRot - rot) / 10;
			
			camera.x = 500 * Math.sin(rot * Math.PI / 180);
			camera.z = 500 * Math.cos(rot * Math.PI / 180);
			camera.y += (mouseY-camera.y)/10;
		}
		
		private function draw():void 
		{
			for (var i:int = 0; i < SPHERE_NUM; i++)
			{
				var material:WireframeMaterial = new WireframeMaterial(0xffffff, 100, 0);
				var sphere:Sphere = new Sphere(material, 5,4,4);
				scene.addChild(sphere);
				sphere.x = Math.random() * 1000-500;
				sphere.y = Math.random() * 1000-500;
				sphere.z = (i % 10 - 5) * 300;
			}
		}
		
	}
	
}