/**
 * Copyright Aksor.Al ( http://wonderfl.net/user/Aksor.Al )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7IHw
 */

// forked from clockmaker's [PV3D] サウンドビジュアライザー
package {
    import flash.events.*;
    import flash.media.*;
    import flash.net.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;

    public class Main extends BasicView {
        private var soundChannel        :SoundChannel;
        private var sphere              :Sphere;
        
        public function Main() {
            // 背景を黒に設定
            viewport.opaqueBackground = 0x000000;
            
            // 球体を作成
            var material:WireframeMaterial = new WireframeMaterial(0x0099FF);
            sphere = new Sphere(material, 800, 20, 20);
            scene.addChild(sphere);
            
            // 音楽読み込み
            var sound:Sound = new Sound(new URLRequest(""));
            soundChannel = sound.play();
            
            // レンダリング
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            // 音量取得
            var volume:Number = (soundChannel.leftPeak + soundChannel.rightPeak) / 2;
            
            // 球体のスケールを制御
            sphere.scale -= 0.02;
            sphere.scale = Math.max(volume, sphere.scale);
            
            // 球体の回転を制御
            sphere.rotationX += soundChannel.leftPeak * 10;
            sphere.rotationY += soundChannel.rightPeak * 5;
        }
    }
}
