/**
 * Copyright sugyan ( http://wonderfl.net/user/sugyan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7IBa
 */

// forked from sugyan's 時計を作ってみる
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.BlurFilter;
    import flash.geom.Point;

    [SWF(width="465", height="465", backgroundColor="0x000000")]
    public class FlashTest extends Sprite {
        private var _prevH:Number;
        private var _prevM:Number;
        private var _prevS:Number;
        private var _texts:Array = [
            new MyText(  1, 120),
            new MyText( 73, 120),
            new MyText(161, 120),
            new MyText(233, 120),
            new MyText(321, 120),
            new MyText(393, 120),
        ];
        private var _bmp:Bitmap = new Bitmap();
        private var _bmd:BitmapData = new BitmapData(465, 465, true, 0xFFFFFF);
        private var _filter:BlurFilter = new BlurFilter();
        
        public function FlashTest() {
            _bmp.bitmapData = _bmd;
            _filter.quality = BitmapFilterQuality.HIGH;
            addChild(_bmp);
            var colon1:MyText = new MyText(130, 110, ":");
            var colon2:MyText = new MyText(290, 110, ":");
            addChild(colon1);
            addChild(colon2);
            for (var i:int = 0; i < _texts.length; i++) {
                addChild(_texts[i]);
            }
            addEventListener(Event.ENTER_FRAME, function (event:Event):void {
                var date:Date = new Date();
                var second:Number = date.seconds;
                var minute:Number = date.minutes;
                var hour:Number   = date.hours;
                if (hour != _prevH) {
                    var h:Number = hour % 10;
                    _changeText(_texts[1], h);
                    if (h != 0 || _texts[0].isEmpty()) {
                        _changeText(_texts[0], (hour - h) / 10);
                    }
                    _prevH = hour;
                }
                if (minute != _prevM) {
                    var m:Number = minute % 10;
                    _changeText(_texts[3], m);
                    if (m == 0 || _texts[2].isEmpty()) {
                        _changeText(_texts[2], (minute - m) / 10);
                    }
                    _prevM = minute;
                }
                if (second != _prevS) {
                    var s:Number = second % 10;
                    _changeText(_texts[5], s);
                    if (s == 0 || _texts[4].isEmpty()) {
                        _changeText(_texts[4], (second - s) / 10);
                    }
                    _prevS = second;
                }
                _bmd.applyFilter(_bmd, _bmd.rect, new Point(0, 0), _filter);
            });
        }
        
        private function _changeText(text:MyText, num:Number):void {
            _bmd.draw(text);
            text.changeText(num);
        }
    }
}


import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;

class MyText extends Sprite {
    private var _text:TextField = new TextField();
    public function MyText(x:Number, y:Number, initText:String = "") {
        addChild(_text);

        _text.x = x;
        _text.y = y;
        _text.width = 72;
        _text.background = false;

        var format:TextFormat = new TextFormat();
        format.color = 0xFFFFFF;
        format.size = 150;
        _text.defaultTextFormat = format;

        _text.text = initText;
    }
    
    public function isEmpty():Boolean {
        if (_text.text.length > 0) {
            return false;
        }
        return true;
    }

    public function changeText(num:Number):void {
    	    _text.text = num.toString();
    }
}