/**
 * Copyright xarple ( http://wonderfl.net/user/xarple )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Hsz
 */

package {

  import flash.display.*;

  import flash.events.Event;

  import flash.geom.*;

  import flash.net.URLRequest;

  import flash.system.LoaderContext;

  import flash.utils.getTimer;

  [SWF(backgroundColor="#000000")]

  public class ch40ex4 extends Sprite {

    protected var viewMatrix:Matrix3D;

    protected var modelMatrix:Matrix3D;

    protected var model:Plane3D;

    protected var texture:BitmapData;

    protected var projectedPoints:Vector.<Number> = new Vector.<Number>();

    public function ch40ex4() {

      this.x = stage.stageWidth/2;

      this.y = stage.stageHeight/2;

      var perspective:PerspectiveProjection = new PerspectiveProjection();

      perspective.fieldOfView = 50;

      perspective.projectionCenter = new Point(0, 0); 

      viewMatrix = new Matrix3D();

      viewMatrix.appendTranslation(0, 0, 20);

      viewMatrix.append(perspective.toMatrix3D());

      modelMatrix = new Matrix3D();

      model = new Plane3D(new Rectangle(-8, -4.5, 16, 9));

      var l:Loader = new Loader();

      l.load(new URLRequest("http://actionscriptbible.com/files/texture-approved.jpg"), new LoaderContext(true));

      l.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoad);

    }

    protected function onLoad(event:Event):void {

      texture = Bitmap(LoaderInfo(event.target).content).bitmapData;

      addEventListener(Event.ENTER_FRAME, onEnterFrame);

    }

    protected function onEnterFrame(event:Event):void {

      modelMatrix.identity();

      modelMatrix.appendRotation(10 * Math.cos(getTimer()/2000), Vector3D.Y_AXIS);

      modelMatrix.appendRotation(10 * Math.sin(getTimer()/2000), Vector3D.X_AXIS);

      var concatenatedMatrix:Matrix3D = modelMatrix.clone();

      concatenatedMatrix.append(viewMatrix);

      Utils3D.projectVectors(

        concatenatedMatrix, model.vertices, projectedPoints, model.uvt);

      graphics.clear();

      graphics.beginBitmapFill(texture, null, false, true);

      graphics.drawTriangles(projectedPoints, model.indices, model.uvt);

    }

  }

}

import flash.geom.Rectangle;

import flash.geom.Vector3D;

class Plane3D {

  public var vertices:Vector.<Number> = new Vector.<Number>();

  public var uvt:Vector.<Number> = new Vector.<Number>();

  public var indices:Vector.<int> = new Vector.<int>();

  public function Plane3D(r:Rectangle):void {

    vertices.push(

      r.left, r.bottom, 0, //bottom left = 0

      r.left, r.top, 0,  //top left = 1

      r.right, r.top, 0, //top right = 2

      r.right, r.bottom, 0 //bottom right = 3

    );

    uvt.push(

      0, 1, 0, //bottom left

      0, 0, 0, //top left

      1, 0, 0, //top right

      1, 1, 0 //bottom right

    );

    indices.push(

      0, 2, 1, //left-side triangle BL->TR->TL

      0, 3, 2 //right-side triangle BL->BR->TR

    );

  }

}