/**
 * Copyright 178ep3 ( http://wonderfl.net/user/178ep3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7HBU
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;

	public class Twist extends Sprite
	{
		private var _camera:Camera;
        private var _video:Video; 
        private var _bmd:BitmapData;
        private var _canvas:Bitmap;
        
        private var _bmdList:Array = [];
        private var max:uint = 120;
        
		public function Twist()
		{
			_camera = Camera.getCamera();
        	_video = new Video(120,120);
        	_video.attachCamera(_camera);
            init(); 
		}
		
		private function init():void
		{
			_bmd = new BitmapData(120,120,true,0);
			_canvas = addChild(new Bitmap(_bmd))as Bitmap;
			
			var scale:Number = 465/120;
			_canvas.scaleX = _canvas.scaleY = scale;
			
			addEventListener(Event.ENTER_FRAME,loop);
		}
         
        private var color:uint=0;
        private var py:uint=0;
        private var length:uint=0;
        
        private function loop(e:Event):void 
        { 
        	var bmd:BitmapData = new BitmapData(120,120,true,0);
        	bmd.draw(_video);
        	_bmdList.unshift(bmd);
        	
        	if(_bmdList.length>max)
        	{
        		var b:BitmapData = _bmdList.pop();
        		b.dispose();
        		b = null;
        	}
        	length = _bmdList.length;
        	_bmd.draw(_video);
        	for(py=0; py<length; py++)
        	{
        	    _bmd.copyPixels(_bmdList[py],new Rectangle(0,py,120,1),new Point(0,py));
        	}
        } 
	}
}