/**
 * Copyright 084 ( http://wonderfl.net/user/084 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7H8B
 */

package {
	import flash.display.Sprite;
	import flash.display.StageScaleMode;
	public class Dock_comp extends Sprite {
		public function Dock_comp() {
			var dock : Dock = new Dock();
			dock.x = 150;
			dock.y = 180;
			addChild(dock);
		}
	}
}

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.Bitmap;
import flash.display.SimpleButton;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.net.navigateToURL;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.geom.Matrix;
import mx.effects.Tween;
import mx.effects.easing.Quadratic;

class Dock extends Sprite {
	private var iconAry : Array = new Array(10);
	private var dockBg : DockBg = new DockBg();
	private var xmlData : XML = new XML();
	private var loader : URLLoader = new URLLoader();
	private var dockTop : int = -30;
	function Dock() {
		addChild(dockBg);
		paramLoader("param.xml");
	}
	private function IconMove(event:Event) : void {
		if(0 <= mouseX && mouseX <= 300 &&
			dockTop <= mouseY && mouseY <= 0){
			dockTop = -120;
			for (var i :int = 0; i < 10; i++){
				var distance : int = mouseX - i * 30 - 15;
				if(-20 * Math.PI < distance && distance < 20 * Math.PI){
					iconAry[i].scaleY += ((1+3*Math.cos(distance/40))
												- iconAry[i].scaleY)/1.5;
					iconAry[i].scaleX += ((1+3*Math.cos(distance/40))
												- iconAry[i].scaleX)/1.5;
					iconAry[i].x += (i*30 + 15 - 120*Math.sin(distance/40)
												- iconAry[i].x)/1.5;
				} else {
					iconAry[i].scaleY += (1 - iconAry[i].scaleY)/1.5;
					iconAry[i].scaleX += (1 - iconAry[i].scaleX)/1.5;
					if(-20 * Math.PI > distance) {
						iconAry[i].x += (i*30 + 120 + 25 - iconAry[i].x)/1.5;
					} else {
						iconAry[i].x += (i*30 - 120 + 5 - iconAry[i].x)/1.5;
					}
				}
			}
		} else {
			dockTop = -30;
			for (i = 0; i < 10; i++){
				iconAry[i].scaleY += (1 - iconAry[i].scaleY)/1.5;
				iconAry[i].scaleX += (1 - iconAry[i].scaleX)/1.5;
				iconAry[i].x += (i*30+15 - iconAry[i].x)/1.5;
			}
		}
		dockBg.x = iconAry[0].x - iconAry[0].width/2;
		dockBg.width = iconAry[9].x + iconAry[9].width/2
								- (iconAry[0].x - iconAry[0].width/2);
	}
	private function paramLoader(url:String) :void{
		loader.addEventListener(Event.COMPLETE, completeFnc);
		var request:URLRequest = new URLRequest(url);
		loader.load(request);
	}
	private function completeFnc(event:Event):void {
		var icons:XML = new XML(loader.data);
		for (var i : int = 0; i < 10; i++){
			iconAry[i] = new Icon(icons.icon[i].image,
								icons.icon[i].name,icons.icon[i].url);
			iconAry[i].x = i * 30 + 15;
			addChild(iconAry[i]);
		}
		addEventListener(Event.ENTER_FRAME, IconMove);
	}
}
class DockBg extends Sprite {
	function DockBg() {
		graphics.beginFill(0xFFFFFF,0.5);
		graphics.drawRect(0,0,300,-30);
		graphics.endFill();
	}
}
class IconImage extends Sprite {
	function IconImage(img:String) {
		var loader:Loader = new Loader();
		loader.contentLoaderInfo.addEventListener(Event.COMPLETE,
																	completeFnc);
		var url:String = img;
		var request:URLRequest = new URLRequest(url);
		loader.load(request);
	}
	private function completeFnc(event:Event):void {
		var loader:Loader = Loader(event.target.loader);
		if(loader.contentLoaderInfo.contentType==
												"application/x-shockwave-flash"){
			addChild(loader);
			loader.width = 30;
			loader.height = 30;
			loader.x = -15;
			loader.y = -30;
		} else {
			var image:Bitmap = Bitmap(loader.content);
			addChild(image);
			image.width = 30;
			image.height = 30;
			image.x = -15;
			image.y = -30;
			image.smoothing = true;
		}
	}
}
class Icon extends Sprite {
	private var icon : SimpleButton = new SimpleButton();
	private var URL : String = new String();
	function Icon(imgUrl:String, txt: String, url: String) {
		URL = url;
		var upImg : IconImage = new IconImage(imgUrl);
		var overImg : IconImage = new IconImage(imgUrl);
		var label : TextField = new TextField();
		label.text = txt;
		label.width = 30;
		label.x = -15;
		label.y = -36;
		var fmt:TextFormat = new TextFormat();
		fmt.color = 0x000000;
		fmt.size = 4;
		fmt.align = TextFormatAlign.CENTER;
		label.setTextFormat(fmt);
		overImg.addChild(label);
		icon.upState = upImg;
		icon.overState = overImg;
		icon.downState = overImg;
		icon.useHandCursor = true;
		icon.hitTestState = upImg;
		addChild(icon);
		icon.addEventListener(MouseEvent.MOUSE_DOWN, jumpStart);
	}
	private function jumpStart(e:Event):void {
		var jump : Tween = new Tween(icon, icon.y, -5, 300, 24);
		jump.easingFunction = Quadratic.easeOut;
		jump.setTweenHandlers(updateJump, reachTop);
	}
	private function updateJump(val:Number):void {
		icon.y = val;
	}
	private function reachTop(val:Number):void {
		var fall:Tween = new Tween(icon, icon.y, 0, 300, 24);
		fall.easingFunction = Quadratic.easeIn;
		fall.setTweenHandlers(updateFall, jumpFinish);
	}
	private function updateFall(val:Number):void {
		icon.y = val;
	}
	private function jumpFinish(val:Number):void {
		var request:URLRequest = new URLRequest(URL);
		navigateToURL(request,"_self");
	}
}