/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7GjD
 */

package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Vector3D;
	import flash.utils.getTimer;
	/**
	 * ...
	 * @author lizhi http://game-develop.net/
	 */
	[SWF(frameRate=60,backgroundColor=0xffffff,width=465,height=465)]
	public class Test3D2 extends Sprite
	{
		private var vs:Vector.<Vector3D> = new Vector.<Vector3D>;
		private var r3d:Vector3D = new Vector3D;
		private var lines:Vector.<Point> = new Vector.<Point>;
		private var clines:Vector.<Vector3D> = new Vector.<Vector3D>;
		public function Test3D2() 
		{
			x = stage.stageWidth / 2;
			y = stage.stageHeight / 2;
			vs.push(
				new Vector3D(-1, -1, 1),
				new Vector3D(1, -1, 1),
				new Vector3D(-1, 1, 1),
				new Vector3D(1, 1, 1),
				new Vector3D(-1, -1, -1),
				new Vector3D(1, -1, -1),
				new Vector3D(-1, 1, -1),
				new Vector3D(1, 1, -1),
				
				new Vector3D(0, 0, 1.5),
				new Vector3D(0, 0, -1.5),
				new Vector3D(1.5, 0, 0),
				new Vector3D(-1.5, 0, 0),
				new Vector3D(0, 1.5, 0),
				new Vector3D(0, -1.5, 0)
			);
			for each(var v:Vector3D in vs) {
				v.scaleBy(70);
			}
			lines.push(
				new Point(0,1),
				new Point(0,2),
				new Point(1,3),
				new Point(2,3),
				new Point(4,5),
				new Point(4,6),
				new Point(5,7),
				new Point(6,7),
				new Point(0,4),
				new Point(1,5),
				new Point(2,6),
				new Point(3,7)
			);
			
			clines.push(
				new Vector3D(0,3,8),
				new Vector3D(1, 2, 8),
				new Vector3D(4,7,9),
				new Vector3D(5, 6, 9),
				new Vector3D(0,6,11),
				new Vector3D(2,4,11),
				new Vector3D(1,7,10),
				new Vector3D(3,5,10),
				new Vector3D(0,5,13),
				new Vector3D(1,4,13),
				new Vector3D(2,7,12),
				new Vector3D(3,6,12)
			);
			addEventListener(Event.ENTER_FRAME, enterFrame);
		}
		
		private function enterFrame(e:Event):void 
		{
			graphics.clear();
			r3d.x += .01;
			r3d.y += .02;
			r3d.z += .03;
			graphics.lineStyle(0);
			var t:Number = 70 * (Math.sin(getTimer() / 300));
			vs[8].z = vs[10].x = vs[12].y = 70 + t;
			vs[9].z = vs[11].x = vs[13].y = -70 - t;
			var vs2:Vector.<Vector3D> = new Vector.<Vector3D>;
			for each(var v:Vector3D in vs) {
				var y:Number = v.y * Math.cos(r3d.x) - v.z * Math.sin(r3d.x);
				var z:Number = v.z * Math.cos(r3d.x) + v.y * Math.sin(r3d.x);
				var x:Number = v.x * Math.cos(r3d.y) - z * Math.sin(r3d.y);
				z = z * Math.cos(r3d.y) + v.x * Math.sin(r3d.y);
				var x_:Number = x * Math.cos(r3d.z) - y * Math.sin(r3d.z);  
				y = y * Math.cos(r3d.z) + x * Math.sin(r3d.z);
				z += 150;
				var fz:Number = 100 / z;
				var sx:Number = x_ * fz;
				var sy:Number = y * fz;
				graphics.drawCircle(sx, sy, 10 * fz);
				vs2.push(new Vector3D(sx, sy, z));
			}
			for each(var line:Point in lines) {
				graphics.moveTo(vs2[line.x].x,vs2[line.x].y);
				graphics.lineTo(vs2[line.y].x,vs2[line.y].y);
			}
			for each(var cline:Vector3D in clines) {
				graphics.moveTo(vs2[cline.x].x,vs2[cline.x].y);
				graphics.curveTo(vs2[cline.z].x,vs2[cline.z].y,vs2[cline.y].x,vs2[cline.y].y);
			}
		}
		
	}

}