/**
 * Copyright WeRelax ( http://wonderfl.net/user/WeRelax )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Fks
 */

package {
	import flash.display.*;
	import flash.geom.Matrix;
	public class Wave extends Sprite {
		private var canvasWidth:Number;
		private var canvasHeight:Number;
		private var opposite:Boolean;
		private var curve:Function;
		
		public function Wave()
		{
			start();
		}
		
		private function drawCircle():void
		{
			graphics.beginFill(0xff0000);
			graphics.drawCircle(100,100,40);
			graphics.endFill();
		}
			
		private function start():void 
		{
			opposite = false;
			curve = Math.sin;
			var g:Graphics = graphics;
			//g.clear();
			var h:Number = stage.stageHeight;
			var w:Number = stage.stageWidth;
			canvasWidth = w;
			canvasHeight = h;			
			var stroke:GraphicsStroke = new GraphicsStroke(10, true, "normal","none","round",3.0, 															new GraphicsSolidFill(0x0000ff));
			//var fill:IGraphicsFill = new GraphicsGradientFill(GradientType.LINEAR, 
			//											    [0xffffff, 0xff0000], 
			//											    [1,1],
			//											    [0,255], 
			//											    getGradMatrix(h, Math.PI * .5));
			var fill:IGraphicsFill = new GraphicsSolidFill(0xff0000);
			var curveWidth:Number = 200;
			var curveHeight:Number = 40; 
			var waveHeight:Number = Math.sin(seed) * curveHeight;
			var seed:Number = Math.random() * Math.PI * 2 - Math.PI;
			var sx:Number = 0; var sy:Number = Math.cos(seed) * 10;
			
			g.drawGraphicsData(Vector.<IGraphicsData>([stroke, fill, getPath(sx, sy, curveWidth, waveHeight, seed) ]));
		}
		
		private function getGradMatrix(length : int, angle : Number) : Matrix 
		{
			var gradMatrix : Matrix = new Matrix();
			gradMatrix.createGradientBox(length, length, angle, 0, 0);
			return gradMatrix;
		}
			
		private function getPath(px:Number, py:Number, w:Number, h:Number, seed:Number):GraphicsPath
		{
			if (w <= 0) throw new Error("Anchura Negativa");
           
			var path:GraphicsPath = new GraphicsPath();
			path.commands = Vector.<int>([ GraphicsPathCommand.MOVE_TO ]);
			path.data = Vector.<Number>([ px, py += Math.sin(seed) * h * .5 ]);
           
			var resolution:int = 5;
			var step:Number = 1 / resolution;
			var stepRad:Number = Math.PI * 2 / resolution;
           
			h *= .5;
				
			while(px < canvasWidth)
			{
				seed += stepRad;
				px += w * step;
				py += curve(seed) * h * stepRad;
				path.commands.push(GraphicsPathCommand.LINE_TO);
				path.data.push(px, py);
			}
           
			path.commands.push(GraphicsPathCommand.LINE_TO);
			path.data.push(px, py += (opposite) ? -canvasHeight : canvasHeight);
			path.commands.push(GraphicsPathCommand.LINE_TO);
			path.data.push(0, py);
	           
			return path;
		}
	}	
}