/**
 * Copyright civet ( http://wonderfl.net/user/civet )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Fgt
 */

//2010-12-17 19:03:36
package
{
    import Box2D.Collision.Shapes.b2FilterData;
    import Box2D.Collision.Shapes.b2Shape;
    import Box2D.Collision.Shapes.b2ShapeDef;
    import Box2D.Common.Math.b2Vec2;
    
    import com.actionsnippet.qbox.*;
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Rectangle;
    
    public class FallDown extends MovieClip
    {
        private var key:int;
        
        private var sim:QuickBox2D;
        private var contact:QuickContacts;
        
        private var character:QuickObject;
        private var charVel:b2Vec2 = new b2Vec2();
        private var boxes:Array = [];
        private var filter:b2FilterData;
        private var oscTheta:Number = 0;
        
        
        public function FallDown()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            sim = new QuickBox2D(this);
            sim.grid(30, 0xcccccc, 1.0);
            
            // set some default colors and create stage walls
            sim.setDefault({fillColor:0x808080, fillAlpha:1, lineThickness:0, lineColor:0xffffff});
            //sim.createStageWalls();
            this.createStageWalls(sim);
            
            //CHARACTER
            character = sim.addBox({x:1, y:1, width:1, height:1, restitution:0, friction:1, fixedRotation:true, allowSleep:false, groupIndex:-1});
            
            //MAP
            boxes[0] = sim.addBox({x:2, y:10.5, width:4, height:1, density:0, restitution:0, friction:0, groupIndex:-1});
            boxes[1] = sim.addBox({x:6, y:12.5, width:4, height:1, density:0, restitution:1, friction:1, groupIndex:-1});
            boxes[2] = sim.addBox({x:10, y:10.5, width:4, height:1, density:1, restitution:0, friction:1, groupIndex:-1, isSleeping:true});
            boxes[3] = sim.addBox({x:15, y:8.5, width:4, height:1, density:0, restitution:0, friction:1, groupIndex:-1});
            
            //CONTACT
            contact = sim.addContactListener();
            contact.addEventListener(QuickContacts.ADD, onAdd);
            sim.addEventListener(QuickBox2D.STEP, onStep);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
            //this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            //
            sim.start();
            //sim.mouseDrag();
        }
        
        private var jumping:Boolean;
        
        private function onStep(e:Event):void
        {    
            charVel = character.body.GetLinearVelocity();
            
            if(key & Key.LEFT) {
                //charVel.x -= 0.8;
                
                charVel.x = -5;
                character.body.SetLinearVelocity(charVel);
            }
            if(key & Key.RIGHT) {
                //charVel.x += 0.8;
                
                charVel.x = 5;
                character.body.SetLinearVelocity(charVel);
            }
            if(key & Key.UP) {
                
                if(!jumping) {
                    //charVel.y -= 0.8;
                    //character.body.SetLinearVelocity(charVel);
                    
                    charVel.y = -10;
                    character.body.SetLinearVelocity(charVel);
                    
                    jumping = true;
                }
            }
            if(key & Key.DOWN) {
                charVel.y += 0.8;
                character.body.SetLinearVelocity(charVel);
            }
            //
            if(charVel.y == 0) jumping = false;
            
            var num:int = boxes.length;
            for (var i:int = 0; i<num; i++){
                var rect:Rectangle = character.userData.getRect(this);
                if (rect.bottom / 30 < boxes[i].y){
                    filter = boxes[i].shape.GetFilterData();
                    filter.groupIndex = 1;
                    boxes[i].shape.SetFilterData(filter);
                }else{
                    filter = boxes[i].shape.GetFilterData();
                    if (filter.groupIndex != -1){
                        filter.groupIndex = -1;
                        boxes[i].shape.SetFilterData(filter);
                    }
                }                
            }            
            
                        
            boxes[3].x = 15 + Math.cos(oscTheta * Math.PI/180);
            
            //ugly imple
            //boxes[3].body.GetLinearVelocity().x = -Math.sin(oscTheta * Math.PI/180);            
            
            oscTheta += 1;
        }
        
        
        private function onAdd(e:Event):void
        {
            if(contact.inCurrentContact(boxes[2])) {
                jumping = false;
            }
            else if(contact.inCurrentContact(boxes[0])) {
                charVel = character.body.GetLinearVelocity();
                charVel.x = 5;
            }
        }
                
        //---Event Handlers---
        
        private function onEnterFrame(e:Event):void
        {
            
        }
        
        private function onKeyDown(e:KeyboardEvent):void
        {
            var code:int = e.keyCode;
            if (code == 37) key |= Key.LEFT;
            else if (code == 39) key |= Key.RIGHT;
            else if (code == 38) key |= Key.UP;
            else if (code == 40) key |= Key.DOWN;
        }
        
        private function onKeyUp(e:KeyboardEvent):void
        {
            var code:int = e.keyCode;
            if (code == 37) key &= ~Key.LEFT;
            else if (code == 39) key &= ~Key.RIGHT;
            else if (code == 38) key &= ~Key.UP;
            else if (code == 40) key &= ~Key.DOWN;
        }
        
        //--------
        
        public function createStageWalls(s:QuickBox2D, params:Object=null):void
        {
            var sw:Number = stage.stageWidth / 30;
            var sh:Number = stage.stageHeight / 30;
            
            var p:Object = {
                lineThickness: 0.0,
                lineColor: 0x0,
                lineAlpha: 1.0,
                fillColor: 0x0,
                fillAlpha: 1.0
            };
            
            if(params != null) {
                for (var key:String in params) {
                    p[key] = params[key];
                }
            }
            
            s.addBox({x:sw / 2, y:sh +0.5, width:sw + 2, height:1, friction:1, density:.0, restitution:0, lineThickness:p.lineThickness, lineColor: p.lineColor, lineAlpha: p.lineAlpha, fillColor: p.fillColor, fillAlpha: p.fillAlpha});
            s.addBox({x:sw / 2, y:0 -0.5, width:sw + 2, height:1, friction:0, density:.0, restitution:0, lineThickness:p.lineThickness,lineColor: p.lineColor, lineAlpha: p.lineAlpha, fillColor: p.fillColor, fillAlpha: p.fillAlpha});
            s.addBox({x:0 -0.5, y:sh / 2, width:1, height:sh, friction:0, density:.0, restitution:0, lineThickness:p.lineThickness,lineColor: p.lineColor, lineAlpha: p.lineAlpha, fillColor: p.fillColor, fillAlpha: p.fillAlpha});
            s.addBox({x:sw +0.5, y:sh / 2, width:1, height:sh, friction:0, density:.0, restitution:0, lineThickness:p.lineThickness,lineColor: p.lineColor, lineAlpha: p.lineAlpha, fillColor: p.fillColor, fillAlpha: p.fillAlpha});
        }
    }
}


class Key
{
    public static const LEFT:int = 1;
    public static const UP:int = 2;
    public static const RIGHT:int = 4;
    public static const DOWN:int = 8;
    
    public function Key()
    {
    }
}