/**
 * Copyright OKASUKE ( http://wonderfl.net/user/OKASUKE )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7FQe
 */

/* 
* SiONをつかって
* 弦楽器的な(Ver.01) 　Simple-Strings
* 最初は弦の動きだったが、ただ揺れるだけなので
* フラグand数値をいじって揺れ方をかえました。
*  
* マウスダウンでピックを持ち　弦をかきならします。
* 音程は左ほど高くなります。
* 音量の操作にはまだ自身がない。(´・ω・｀)
* エフェクト関連も・・・(´・ω;;;;;・・・
* ギターにしてコードをかかき鳴らしたいけど
* キーボードと組み合わせるとじぬ。
* 
* 2010/11/10 @okasuke
* TODO:弦の振幅によって音量を変える予定
*/ 


package {
        
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;   
    import flash.ui.*   
    import org.si.sion.*;
    import org.si.sion.utils.SiONPresetVoice;    
    
    import net.hires.debug.Stats;
    
    [SWF(width = "465", height = "465", backgroundColor = "0xFFFFFF", frameRate = "60")] 
     
    public class Jam_NiSanKaDekinakaltuTa extends Sprite {
            
        private var _gen_E:Gen02;        
            
        private var _pic:Pic01;
        private var _picLayer:Sprite;
        private var _genLayer:Sprite;            
        
        private var _prevmouseY:Number;
        private var _picpower:Number;
        private var _mouseDown:Boolean;
            
        private var _picBitmapData:BitmapData;
        private var _genBitmapData:BitmapData;
            
        private static const ZERO:Point = new Point(0, 0);
            
        private var _driver:SiONDriver;
        private var _presetVoice:SiONPresetVoice;
        private var _voice:SiONVoice;
            
            
        public function Jam_NiSanKaDekinakaltuTa() { 
            Mouse.hide();               
            var stats:Stats=new Stats();
            addChild( stats );
            setsion();
            setpic();
        }
        
        private function setsion():void {
            _driver = new SiONDriver();
            _presetVoice = new SiONPresetVoice();
            _voice = new SiONVoice();
            _voice = _presetVoice["valsound.guitar1"];
            _driver.play();
                
        }
        
        //x座標が大きくなるにつれ音程を上げる
        public var _notes :Array = [50,51,52,53,54, 55,56,57,58, 59,60,61,62, 63,64,65,66,
                67,68,69,70, 71,72,73,74, 75,76,77,78, 79,80,81,82,83 ];
        
        private function setpic():void {
            
            //ピックをセッティング
            _pic = new Pic01(40);
            _pic.x -= _pic.width / 2;
            _pic.y -= _pic.height / 2;            
            _picLayer = new Sprite();
            addChild(_picLayer);            
            _picLayer.addChild(_pic);            
                
            _picBitmapData = new BitmapData(465, 465, true, 0x00000000);
            _picBitmapData.lock();
            
            _picBitmapDataMatrix = new Matrix();    
            
            //弦を生成
            create_gen();
        }
        
        private function create_stageline():void {
            var backLine:Sprite = new Sprite();            
            
            graphics.clear();
            graphics.lineStyle(3, 0x000000, 1);            
            graphics.moveTo(0, 0);
            graphics.lineTo(465, 0);
            graphics.lineTo(465, 465);
            graphics.lineTo(0, 465);
            graphics.lineTo(0, 0);
            graphics.endFill();
        }
            
        private function create_gen():void {                
            
            //弦をセッティング
            _genLayer = new Sprite();
            addChild(_genLayer);
            
            _genBitmapData = new BitmapData(465, 465, true, 0x00000000);
            _genBitmapData.lock();            
            
            _gen_E = new Gen02(0, 200, 0x000000);
                
            //Play用をEventを生成
            addEventListener(Event.ENTER_FRAME, playing);
            addEventListener(MouseEvent.MOUSE_DOWN, picking);            
        }        
        
        private var _picBitmapDataMatrix:Matrix;
        private var _noteid:int=0;
        
        private function playing(e:Event):void {
            
            if (_prevmouseY != 0 ) {
                _picpower = mouseY - _prevmouseY;                
            }
            
            if (_mouseDown) _picLayer.rotationX += (80 - _picLayer.rotationX) * 0.2;
            else  _picLayer.rotationX += (0 - _picLayer.rotationX) * 0.2;            
            
            _picLayer.x = mouseX;
            _picLayer.y = _prevmouseY = mouseY;                
            
            _picBitmapDataMatrix.identity();            
            _picBitmapDataMatrix.translate(_picLayer.x, _picLayer.y);
            _picBitmapData.fillRect(_picBitmapData.rect, 0x00000000);
            _picBitmapData.draw(_picLayer, _picBitmapDataMatrix);
                
            _genBitmapData.fillRect(_genBitmapData.rect, 0x00000000);
            _genBitmapData.draw(_genLayer);
            
            _genLayer.graphics.clear();    
            if (_picBitmapData.hitTest(ZERO, 128, _genBitmapData, ZERO, 128) && _mouseDown && _picpower != 0) {
                    
                _gen_E.genhitset(_picpower, _picLayer.x, _picLayer.y);
                _gen_E.draw(_genLayer.graphics);
                
                _noteid =  _gen_E.noteindex();
                
                //音をならす予定
                _driver.volume = Math.abs(_picpower / 20);                
                _driver.noteOn(_notes[_noteid], _voice, 4);
                _picpower = 0;
            } else {
                
                _gen_E.genclear();
                _gen_E.draw(_genLayer.graphics);
                
                //ここでnoteOff 大丈夫かな・・・
                _driver.noteOff(_notes[_noteid]);                
            }
            
            create_stageline();
        }
        
        private function picking(e:MouseEvent):void {            
            
            removeEventListener(MouseEvent.MOUSE_DOWN, picking);            
            addEventListener(MouseEvent.MOUSE_UP, pickup);                
            _mouseDown = true;                
        }
        
        private function pickup(e:MouseEvent):void {
            removeEventListener(MouseEvent.MOUSE_UP, pickup);
            addEventListener(MouseEvent.MOUSE_DOWN, picking);
            _mouseDown = false;
            _picLayer.rotationX = 0;            
        }            
    }
}

///////////////////////////////////////////////////////////
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.geom.Point;    
    
    internal class Gen02
    {
        
        private var _x:Number;
        private var _y:Number;
        private var _color:uint;
        private var _p:Vector.<GenPoint01> = new Vector.<GenPoint01>();
        
        private var _picpower:Number;
        private var _hitPointX:Number;
        private var _hitPointY:Number;
        private var _hitflg:Boolean;
        
        private static const _MAXINDEX:int = 32;
        private static const _EMIT:int = 15;
        
        public function Gen02(x_:Number=0, y_:Number=0, color_:Number=0) 
        {            
            _x = x_;
            _y = y_;
            _color = color_;
            _picpower = 0;
            _hitPointX = 0;
            _hitPointY = 0;            
            
            createPoint();
        }    
        
        //初期値ポイント設定
        private function createPoint():void {
            var emit:int;
            
            for (var i = 0; i < _MAXINDEX; i++) {
                _p[i] = new GenPoint01();
                _p[i].x = emit;
                _p[i].defaltY = _y;
                _p[i].y = _y;
                _p[i].ax = 0;
                _p[i].ay = 0;
                _p[i].vx = 0;
                _p[i].vy = 0;
                emit += _EMIT;                
            }
        }
        
        private var _GtargetY:Number = 0;
        public function draw( g:Graphics ):void {                
            
            _GtargetY = _y;
            var index:int = 0;
            
            g.clear();
            g.lineStyle( 2, _color );
            
            if (_picpower != 0 && _hitPointX != 0) {                
                index = Math.floor(_hitPointX / 15);
                //trace("index:" + index);
                if (index <= 0 ) {                    
                } else if (index >= _MAXINDEX-1) {
                    //何もしない
                }  else {                    
                    genY_move(index);
                }
                
                if (_picpower < 0) _GtargetY = _y + (_picpower * 0.2);
                else if (_picpower > 0) _GtargetY = _y + (_picpower * 0.2);
            } 
            
            var x:int = 0;
            for (var j:int = 0; j < _p.length; j++) {
                if (_p[j].hitflg) {    
                    
                    _p[j].vy += (_GtargetY+x - _p[j].y) * 0.7;                    
                    _p[j].y += _p[j].vy;                    
                    _p[i].vy *= 0.9;
                    _p[j].hitflg = false;
                    
                } else {
                    
                    _p[j].targetY = _y;
                    _p[j].vy += (_y - _p[j].y) * 0.1;                    
                    _p[j].y+= _p[j].vy;                     
                    _p[j].vy *= 0.9;
                }
            }            
            
            g.moveTo(_p[0].x, _p[0].y);            
                    
            for(var i:int = 0; i < _p.length-1; i++){
                var c_x:Number = (_p[i].x+_p[i+1].x) / 2;
                var c_y:Number = (_p[i].y+_p[i+1].y) / 2;
                g.curveTo(_p[i].x, _p[i].y, c_x, c_y);
            }
            g.lineTo(_p[i].x, _p[i].y);
                
            g.endFill();
        }
        
        //moveするポイント
        private function genY_move(cnt:int):void {
            
            var ty:Number = _GtargetY;
            _p[cnt].hitflg = true;
            if (cnt > 0) {
                _p[cnt-1].hitflg = _p[cnt].hitflg = _p[cnt+1].hitflg = true;
            } else if (cnt >= 31) {
                _p[cnt - 1].hitflg = _p[cnt].hitflg = true;
            }
                        
        }
            
        public function set picpower(value:Number):void {
            _picpower = value;
        }
        
        public function set hitpointX(value:Number):void {
            _hitPointX = value;
        }
        
        public function set hitpointY(value:Number):void {
            _hitPointY = value;
        }
        
        public function noteindex():int {
            var note:int = Math.floor(_hitPointX / 15);
            note = (note<0) ? 0 : note;
            return note;
        }
        
        public function genhitset(picpower_:Number, x_:Number, y_:Number):void {
            _picpower = picpower_;
            _hitPointX = x_;
            _hitPointY = y_;            
        }
        
        public function genclear():void {
            _picpower = 0;
            _hitPointX = 0;
            _hitPointY = 0;
        }        
    }

////////////////////////////////////////////////////////////

    import flash.display.Sprite;
    import flash.display.Graphics;    
    
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;    
    
    //Wonderfl用ピック
    internal class Pic01 extends Sprite
    {
        
        private var _color:Number;
        private var _picpower:Number;
        
        public function Pic01( size:Number = 20) 
        {
            addtext();
            
            var g:Graphics = graphics;
            _color = 0x333333;            
            g.clear();            
            g.beginFill(_color);            
            g.moveTo(5, 0);
            g.lineTo(size-5, 0);
            g.lineTo(size, 5);
                
            g.lineTo(size / 2, size);
            g.lineTo(0, 5);
            g.lineTo(5, 0);            
            g.endFill();            
            
            cacheAsBitmap = true;                    
        }        
        
        public function set(value:Number):void {
            _picpower = value;
        }
        public function get():Number {
            return _picpower;
        }    
        
        public function addtext(label:String="wonderfl"):void {
            var text:TextField = new TextField();
            text.defaultTextFormat = new TextFormat('Verdana', 8, 0xffffff);
            text.autoSize = TextFieldAutoSize.LEFT
            text.selectable = false;
            text.text = label;
            text.y = 3;
            this.addChild(text);
        }
    }  
////////////////////////////////////////////////////////////////////////////////

//座標データetc
    //処理速度によってはpublic変数にする。
    internal class GenPoint01
    {
        private var _defaultX:Number = 0;
        private var _defaultY:Number = 0;
        private var _targetY:Number = 0;
        
        private var _x:Number = 0;
        private var _y:Number = 0;
        private var _ax:Number = 0;
        private var _ay:Number = 0;
        private var _vx:Number = 0;
        private var _vy:Number = 0;
        private var _k:Number = 0;
        
        private var _hitflg:Boolean = false;
        private var _index:uint = 0;
        
        
        public function GenPoint01() 
        {
            
        }
        
        public function set x(value:Number):void {
            _x = value;
        }        
        public function get x():Number {
            return _x;
        }
        
        public function set y(value:Number):void {
            _y = value;
        }
        public function get y():Number {
            return _y;
        }
        
        public function set ax(value:Number):void {
            _ax = value;
        }
        public function get ax():Number {
            return _ax;
        }
        
        public function set ay(value:Number):void {
            _ay = value;
        }
        public function get ay():Number {
            return _ay;
        }
        
        public function set vx(value:Number):void {
            _vx = value;
        }
        public function get vx():Number {
            return _vx;
        }        
        
        public function set vy(value:Number):void {
            _vy = value;
        }
        public function get vy():Number {
            return _vy;
        }
        
        public function set defaltY(value:Number):void {
            _defaultY = value;
        }        
        public function get defaltY():Number {
            return _defaultY;
        }
        
        public function set hitflg(value:Boolean):void {
            _hitflg = value;
        }
        public function get hitflg():Boolean {
            return _hitflg;
        }
        
        public function set targetY(value:Number):void {
            _targetY = value;
        }
        public function get targetY():Number {
            return _targetY;
        }
        
    }