/**
 * Copyright MMMMMonchi ( http://wonderfl.net/user/MMMMMonchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7FNh
 */

// forked from mashang163's forked from: forked from: forked from: Fire
// forked from fmk's forked from: forked from: Fire
// forked from Rodlaiz's forked from: Fire
// forked from Saqoosha's Fire
package {
    import flash.geom.Rectangle;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.DisplayObject;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.ConvolutionFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.system.LoaderContext;
    import flash.net.SharedObject;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.display.BitmapDataChannel;
    import flash.geom.Matrix;
    import flash.utils.getTimer;
    
    [SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]

    public class Fire extends Sprite {
        
        private static const ZERO_POINT:Point = new Point();
        private const FIRE_WIDTH:int = 465;
        private const FIRE_HEIGHT:int = 465;
        
        private var _fireColor:BitmapData;
        private var _currentFireColor:int;
        
        private var _canvas:Sprite;
        private var _grey:BitmapData;
        private var _spread:ConvolutionFilter;
        private var _cooling:BitmapData;
        private var _color:ColorMatrixFilter;
        private var _offset:Array;
        private var _fire:BitmapData;
        private var _palette:Array;
        private var _zeroArray:Array;
        
        private var _coolingH:BitmapData;
        private var _coolingV:BitmapData;
        private var _coolingHBuffer:BitmapData;
        private var _coolingVBuffer:BitmapData;
        private var _rectH:Rectangle = new Rectangle(FIRE_WIDTH-1,0,1,FIRE_HEIGHT);
        private var _rectV:Rectangle = new Rectangle(0,FIRE_HEIGHT-1,FIRE_WIDTH,1);
        
        public function Fire() {
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.stage.quality = StageQuality.LOW;
            
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, this._onLoaded);
            loader.load(new URLRequest('http://saqoosha.net/lab/Moyasu/srcview/source/fire-color.png'), new LoaderContext(true));
        }
        
        private function _onLoaded(e:Event):void {
            this._fireColor = Bitmap(LoaderInfo(e.target).loader.content).bitmapData;
            
            this._canvas = new Sprite();
            this._canvas.graphics.beginFill(0x0, 0);
            this._canvas.graphics.drawRect(0, 0, 465, 465);
            this._canvas.graphics.endFill();
            this._canvas.addChild(this._createEmitter());
            
            this._grey = new BitmapData(465, 465, false, 0x0);
            this._spread = new ConvolutionFilter(3, 3, [0, 1, 0,  1, 1, 1,  0, 1, 0], 5);
            this._cooling = new BitmapData(465, 465, false, 0x0);
            this._coolingHBuffer = new BitmapData(1,FIRE_HEIGHT,false,0x0);
            this._coolingVBuffer = new BitmapData(FIRE_WIDTH,1,false,0x0);
            this._coolingH = new BitmapData(FIRE_WIDTH, FIRE_HEIGHT, false, 0x0);
            this._coolingV = new BitmapData(FIRE_WIDTH, FIRE_HEIGHT, false, 0x0);
            this._offset = [new Point(), new Point()];
            this._fire = new BitmapData(465, 465, false, 0x0);
            this.addChild(new Bitmap(this._fire));
            
            this._createCooling(0.5);
            this._createPalette(this._currentFireColor = 0);
            
            this._coolingH.perlinNoise(30, 50, 1, 982374, true, false, BitmapDataChannel.ALPHA, true);
            this._coolingH.applyFilter(this._coolingH, this._coolingH.rect, ZERO_POINT, this._color);
            this._coolingV.perlinNoise(30, 50, 1, 546241, true, false, BitmapDataChannel.ALPHA, true);
            this._coolingV.applyFilter(this._coolingV, this._coolingV.rect, ZERO_POINT, this._color);
            
            this.addEventListener(Event.ENTER_FRAME, this._update);
            this.stage.addEventListener(MouseEvent.CLICK, this._onClick);
        }
        
        private function _onClick(e:MouseEvent):void {
            if (++this._currentFireColor == int(this._fireColor.height / 32)) {
                this._currentFireColor = 0;
            }
            this._createPalette(this._currentFireColor);
        }
        
        private function _createEmitter():DisplayObject {
            var tf:TextField = new TextField();
            tf.selectable = false;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.defaultTextFormat = new TextFormat('Verdana', 80, 0xffffff, true);
            tf.text = 'Wonderfl';
            tf.x = (465 - tf.width) / 2;
            tf.y = (465 - tf.height) / 2;
            return tf;
        }
        
        private function _createCooling(a:Number):void {
            this._color = new ColorMatrixFilter([
                a, 0, 0, 0, 0,
                0, a, 0, 0, 0,
                0, 0, a, 0, 0,
                0, 0, 0, 1, 0
            ]);
        }
        
        private function _createPalette(idx:int):void {
            this._palette = [];
            this._zeroArray = [];
            for (var i:int = 0; i < 256; i++) {
                this._palette.push(this._fireColor.getPixel(i, idx * 32));
                this._zeroArray.push(0);
            }
        }
        
        private function _update(e:Event):void {
            this._grey.draw(this._canvas);
            var rect:Rectangle = this._grey.getColorBoundsRect(0xFF000000,0xFFFFFF,false);

            this._grey.applyFilter(this._grey, rect, rect.topLeft, this._spread);
            this._grey.draw(this._coolingH,null,null,BlendMode.SUBTRACT,rect);
            this._grey.draw(this._coolingV,null,null,BlendMode.SUBTRACT,rect);
            
            _coolingHBuffer.copyPixels(_coolingH,_rectH,ZERO_POINT);
            _coolingH.scroll(1,0);
            _coolingH.copyPixels(_coolingHBuffer,_coolingHBuffer.rect,ZERO_POINT);
            
            _coolingVBuffer.copyPixels(_coolingV,_rectV,ZERO_POINT);
            _coolingV.scroll(0,1);
            _coolingV.copyPixels(_coolingVBuffer,_coolingVBuffer.rect,ZERO_POINT);
            
            //this._grey.threshold(this._grey,rect,rect.topLeft,"==",0xFF000000,0,0x00FFFFFF);
            this._grey.scroll(0, -2);
            this._fire.paletteMap(this._grey, rect, rect.topLeft, this._palette, this._zeroArray, this._zeroArray, null);
        }
    }
}