/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/7FFq
 */

package {
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.utils.*;
    import Box2D.Dynamics.*;
    import Box2D.Collision.Shapes.*;
    import Box2D.Collision.*;
    import Box2D.Common.Math.b2Vec2;

    import com.demonsters.debugger.MonsterDebugger;

    public class FlashTest extends MovieClip {
        private var sim:QuickBox2D;
        private var contacts:QuickContacts;
        private var sprites:Array = [];

        public function FlashTest() {
            sim = new QuickBox2D(this, {debug:false});
            sim.createStageWalls();

            for (var i:int = 0; i < 5; i++){
                sim.addCircle({x:2 + i, y:2 + i*2, radius:1});
            }

            sim.start();
            sim.mouseDrag();

            var contacts:QuickContacts = sim.addContactListener();
            contacts.addEventListener(QuickContacts.ADD, function onAdd(evt:Event):void {
                var p:b2Vec2 = contacts.currentPoint.position;
                var sprite:Sprite = new Sprite();
                var g:Graphics = sprite.graphics;
                g.beginFill(0xff0000, 1);
                g.drawCircle(0, 0, 10);
                sprite.x = p.x * 30;
                sprite.y = p.y * 30;

                addChild(sprite);
                sprites.push(sprite);
            });
            addEventListener(Event.ENTER_FRAME, onLoop);
        }

        private function onLoop(evt:Event):void {
            var newsprites:Array = [];
            for (var i:Number = 0; i < sprites.length; i++) {
                var sprite:Sprite = sprites[i];
                sprite.alpha *= 0.9;
                if (sprite.alpha < 0.1) {
                    removeChild(sprite);
                } else {
                    newsprites.push(sprites[i]);
                }
            }
            sprites = newsprites;
        }
    }
}
