/**
 * Copyright kuma360 ( http://wonderfl.net/user/kuma360 )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/7FAy
 */

// print this marker: http://saqoosha.net/lab/FLARToolKit/flarlogo-marker.pdf
package {
   
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Plane;

    import org.libspark.flartoolkit.example.PV3DARApp;
    
    [SWF(width=465, height=465)]
    public class Main extends PV3DARApp {
       
        private var _plane:Plane;
        private var _BM:BitmapMaterial;
        private var _BD:BitmapData;
                
                
        public function Main () {
            Wonderfl.capture_delay( 8 );
            addEventListener(Event.INIT, _onInit);
            init('http://assets.wonderfl.net/static/flar/camera_para.dat', 'http://assets.wonderfl.net/static/flar/flarlogo.pat');
        }

        private function _onInit(e:Event):void {
            
            _BD = new BitmapData ( stage.stageWidth , stage.stageHeight , false , 0 ) ;
            _BD.draw ( stage ) ;
            
            _BM = new BitmapMaterial ( _BD ) ;
            _plane = new Plane( _BM , 80, 80); 
            _markerNode.addChild(_plane); 
            
            addEventListener ( Event.ENTER_FRAME , _on ) ;
            
        }
        
        private function _on ( e:Event ):void {
            _BD.draw ( stage ) ;
        }
        
    }
}
