/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7F3y
 */

package {
    import flash.events.TimerEvent;
    import flash.utils.Timer;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private const CENTER:Number = 200; // 中央位置
        private const RADIUS:Number = 100; // 半径
        
        private var _degress:Number = 0;
        
        public function FlashTest() {
            
            this.graphics.lineStyle(1, 0);
            
            // ベースの円を描画
            this.graphics.beginFill(0xff0000);
            this.graphics.drawCircle(CENTER,CENTER,RADIUS);
            this.graphics.endFill();
            
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
        }
        
        /**
         * 線の描画
         * 指定された角度の線を書く
         */
        private function writeLine(degress:Number):void {
            var radian:Number = degress * Math.PI/180;
            this.graphics.moveTo(CENTER, CENTER);
            var xPos:Number = Math.cos(radian) * RADIUS + CENTER;
            var yPos:Number = Math.sin(radian) * RADIUS + CENTER;
            this.graphics.lineTo(xPos,yPos);
        }
        
        /**
         * タイマーイベント
         * 線を描画する
         */
        private function onTimer(e:TimerEvent):void {
            _degress += 11;
            writeLine(_degress);
        }


    }
}