/**
 * Copyright yurji ( http://wonderfl.net/user/yurji )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Ep2
 */

package {
    import flash.events.Event;
    import flash.display.Sprite;
    
    import org.papervision3d.view.*
    import org.papervision3d.materials.*
    import org.papervision3d.objects.primitives.*    
    import org.papervision3d.materials.shadematerials.*
    import org.papervision3d.lights.*
    
    public class FlashTest extends Sprite {
        
        private var sphere:Sphere;
        private var world:BasicView;
        public function FlashTest() {
            // write as3 code here..
            // PV3Dライブラリをインポート

        // 3Dの初期設定をおこないます
        world = new BasicView()
        world.startRendering()
        addChild(world)
        
        // ライトを作成します
        var light:PointLight3D = new PointLight3D()
        
        
        // マテリアルを作成します
        // ワイヤーフレームマテリアルは引数に16進数の色を指定します
        //var material:WireframeMaterial = new WireframeMaterial(0xFF0000)
        
        var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0x3399FF)
        
        
        // 球面(Sphere)を作成します
        // Sphereの引数の1番目にマテリアルを指定します
        // 2〜4番目の引数は球面の半径、横のポリゴン分割数、縦のポリゴン分割数
        sphere = new Sphere(material, 400, 15, 15);
        
        // 3D空間に球面を追加します
        world.scene.addChild(sphere)
        
        addEventListener(Event.ENTER_FRAME, onEnter);

        }
        
        private var rot:Number = 0;
        public function onEnter(e:Event):void
        {
            //sphere.rotationY += 1;
            sphere.rotationX += 1;
           
           rot += 0.5 // 毎フレーム角度を0.5度ずつ足していく
     
          // 角度に応じてカメラの位置を設定
            world.camera.x = 1000 * Math.sin(rot * Math.PI / 180)
            world.camera.z = 1000 * Math.cos(rot * Math.PI / 180) 
            
        }
        
        
        
    }
}