/**
 * Copyright hiro_rec ( http://wonderfl.net/user/hiro_rec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7ETP
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.GlowFilter;
    import flash.geom.Point;

    [SWF(backgroundColor='#000000', frameRate=60)]
    
    public class Main extends Sprite
    {
        private var container:Sprite;
        private var circle:Sprite;
        private var bmd:BitmapData;
        private var bmp:Bitmap;
        
        
        public function Main()
        {
            initDisplay();
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function initDisplay():void
        {
            graphics.beginFill(0x0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            container = new Sprite();
            
            circle = new Sprite()
            circle.graphics.beginFill(0xFF0000)
            circle.graphics.drawRect(0, 0, 300, 5);
            container.addChild(circle);
            
            bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00000000);
            bmp = new Bitmap();
            bmp.bitmapData = bmd;
            bmp.blendMode = BlendMode.HARDLIGHT;
            addChild(bmp);
        }
        
        private var angleX:Number = 0;
        private var angleY:Number = 0;
        
        private function enterFrameHandler(event:Event):void
        {
            bmd.draw(container);
            
            angleX += 5;
            angleY += 0.5;
            
            var px:Number = Math.cos(Math.PI / 180 * angleX) * stage.stageWidth / 10;
            var py:Number = Math.sin(Math.PI / 180 * angleY) * stage.stageHeight / 2.4;
            
            circle.x = px + circle.width / 4;
            circle.y = py + stage.stageHeight / 2;
            
            var point:Point = new Point();
            
            bmd.threshold(bmd, bmd.rect, point, "<", 0x00333333, 0x00000000, 0x00FF0000, true);
            
            var matrix:Array = [
                                1, 0, 0, 0, 0,
                                0, 1, 0, 0, 5,
                                0, 0, 1, 0, 2,
                                0, 0, 0, 1, -0.3
                                ];
            
            var matrixFilter:ColorMatrixFilter = new ColorMatrixFilter(matrix);
            
            bmd.applyFilter(bmd, bmd.rect, point, new GlowFilter(0x000000, 1, 6, 6, 10));
            bmd.applyFilter(bmd, bmd.rect, point, new GlowFilter(0x0011FF, 1, 6, 6, 10));
            bmd.applyFilter(bmd, bmd.rect, point, new BlurFilter(7, 7));
            bmd.applyFilter(bmd, bmd.rect, point, matrixFilter);
            bmd.applyFilter(bmd, bmd.rect, point, new GlowFilter(0x0000FF, 3, 3, 1, 5));
        }
    }
}
