/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Dxr
 */

// forked from heart_thai's Roku Shooting Version
// forked from buccchi's オッス、おらロク！（墨エフェクト）
// forked from buccchi's オッス、おらロク！
//某鋼板は256回攻撃しても破壊できないので避けてください
//ロクと某鋼板が衝突すると画面がとまります
//最初の読み込み時少し重いです
//hitTestObjectがうまく機能しなかったので平方根によるテキトーな当たり判定してます。。。
//交差判定による当たり判定とかのほうが正確に判定できる？？？
/**
 * 画面クリックで輪郭線表示+ズーム+スロー再生
 * 再度クリックで元に戻ります
 *
 * ロク（猫）の写真はこちら
 * http://www.flickr.com/photos/40441900@N08/
 * Blenderでモデリング
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.utils.Timer;
    import net.hires.debug.Stats;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.lights.PointLight3D;
    public class FlashTest extends Sprite {
        private var mountens:Vector.<DAE>;
        private var steelPlates:Vector.<Cube>;
        private var powers:Vector.<Sphere>
        private var roku:DAE;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var vp:Viewport3D;
        private var rd:BasicRenderEngine;
        private var tm:Timer;
        private var gameOver:Boolean = false;
        private var light:PointLight3D;
        private var flatShadeMate:FlatShadeMaterial;
        private var materials:MaterialsList;
        private const COLLISION_DIST : int = 30; //ロクと鋼板Cubeとの当たり判定用距離
        private const PLATE_SIZE : int = 120; //鋼板Cubeの一辺のサイズ
        private const PLATE_THICK : int = 5; //鋼板Cubeの厚さ
        public function FlashTest():void {
            addChild( new Stats() );
            scene = new Scene3D();
            camera = new Camera3D();
            rd = new BasicRenderEngine();
            vp = new Viewport3D(stage.stageWidth , stage.stageHeight );
            addChild(vp);
            camera.zoom = 50;
            
            //光源設定
            light = new PointLight3D();
            light.y = -8000;
            light.x = -8000;
            light.z = -8000;
            //鋼板用マテリアル設定
            flatShadeMate = new FlatShadeMaterial(light, 0xdddddd, 0x555555);
            flatShadeMate.doubleSided = true;
            materials = new MaterialsList(
                {front:flatShadeMate,back:flatShadeMate,right:flatShadeMate,left:flatShadeMate,top:flatShadeMate,bottom:flatShadeMate});

            createMouten();
            createSteelPlate();
            createRoku();
            
            camera.y = 100; 
            
            powers = new Vector.<Sphere>();
            tm = new Timer(200);
            tm.addEventListener(TimerEvent.TIMER , shotting );
            
            this.addEventListener(Event.ENTER_FRAME , loop);
            stage.addEventListener(MouseEvent.MOUSE_DOWN , shot );
            stage.addEventListener(MouseEvent.MOUSE_UP , stopShot );
        }
        private function shot(e:MouseEvent):void {
            tm.start();
        }
        private function stopShot(e:MouseEvent):void {
            tm.stop();
        }
        private function shotting(e:TimerEvent):void {    
            var c:ColorMaterial = new ColorMaterial(0xFF0000,0.5);
            var p:Sphere = new Sphere( c , 50 );
            p.x = roku.x;
            p.y = roku.y;
            p.z = roku.z;
            scene.addChild(p);
            powers.push(p);
        }
        private function createMouten():void {
            mountens = new Vector.<DAE>();
            for(var i:int = 0 ; i<=20 ; i++){
                var mountain:DAE = new DAE();
                mountain.load("http://7980.oui-imja.com/wonderfl/201002/mountain.dae");
                scene.addChild(mountain); 
                mountain.y = -100;
                mountain.scale = 10;
                mountain.x = 1000-(Math.random()*2000);
                mountain.z = 1000 - (Math.random() * 2000);
                mountens.push(mountain);
            }
                    
        }
        private function createSteelPlate():void {
            steelPlates = new Vector.<Cube>();
            for(var i:int = 0 ; i<=1 ; i++){
                var steelPlate:Cube = new Cube(materials,PLATE_SIZE,PLATE_THICK,PLATE_SIZE,1,1,1);
                scene.addChild(steelPlate); 
                steelPlate.y = 100;
                steelPlate.x = 1000-(Math.random()*2000);
                steelPlate.z = 1000 - (Math.random() * 2000);
                steelPlates.push(steelPlate);
            }
                    
        }
        private function createRoku():void{
            roku = new DAE();
            roku.load("http://7980.oui-imja.com/wonderfl/201002/roku.dae");
            scene.addChild(roku);
            roku.scale = 20;
            roku.rotationY = 90;
            roku.z = -700;
        }
        private function loop(event:Event):void {
            if(gameOver){return;} //ゲームオーバー時は処理をストップ
            var sx:Number = (mouseX-(stage.stageWidth/2)) - roku.x;
            roku.x += sx/10;
            for (var i:String in mountens) {
                mountens[i].z -= 50;
                if (mountens[i].z < -1000) {
                    mountens[i].z = 1000;
                    mountens[i].x = 1000-(Math.random()*2000);
                }
            }
            for (i in steelPlates) {
                steelPlates[i].z -= 50;
                steelPlates[i].rotationX -= 20;
                if (checkCollision(roku.x,roku.z,(steelPlates[i].x+(PLATE_SIZE/4)),steelPlates[i].z)) {
                    gameOver = true;
                    return;
                }
                if (steelPlates[i].z < -1000) {
                    steelPlates[i].z = 1000;
                    steelPlates[i].x = 1000-(Math.random()*2000);
                }
            }
            for (i in powers) {
                powers[i].z += 150;
                if (powers[i].z > 5000) {
                    scene.removeChild(powers[i]);
                    powers.splice(int(i), 1);
                }
            }
            rd.renderScene(scene , camera, vp);
        }
        private function checkCollision(rokuX:int,rokuZ:int,cubX:int,cubZ:int):Boolean {
            //平方根を用いてロクとと鋼板Cubeとの距離を計算
            var dist : Number = Math.sqrt(Math.pow(rokuX-cubX,2)+Math.pow(rokuZ-cubZ,2));
            if (dist > COLLISION_DIST) {
                return false;
            } else {
                return true;
            }          
        }
    }
}
