/**
 * Copyright amyneon ( http://wonderfl.net/user/amyneon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7Dxm
 */

/**
 * Copyright amyneon ( http://wonderfl.net/user/amyneon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eSAZ
 */

// forked from civet's Bad Apple!! 東方･影絵  × Pixel3D
//---------------------------
//Pause/Resume: [SPACE]
//Change mode: [Z]
//Drag mouse to rotate
//Click the bar below to seek
//original video from: (http://www.nicovideo.jp/watch/sm8628149)
//---------------------------
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.net.NetStream;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.ui.Keyboard;
    import flash.utils.Timer;
    import flash.utils.getTimer;
    import flash.events.TimerEvent;
    
    import frocessing.color.ColorHSV;
    
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    
    [SWF(backgroundColor="0x000000", frameRate="25")]
    /**
     * @author civet
     */    
    public class BadApplePixels extends BasicView
    {
        private var VIDEO_WIDTH:int = 120;
        private var VIDEO_HEIGHT:int = 68;
        private var WIDTH:int = 640;//VIDEO_WIDTH*4;
        private var HEIGHT:int = 480;//VIDEO_HEIGHT*4;
        
        private var bfx:BitmapEffectLayer;
        private var pixels:Pixels;
        private var buffer:BitmapData;
        private var player:VideoPlayer;
        private var stream:NetStream;
        private var mode:int = 0;
        
        private var bar:Sprite;
        private var slider:Shape;
        private var status:TextField;
        private var paused:Boolean;
        private var frozen:Boolean;
        
        
        private const SIZE:int = stage.stageHeight/45;
        private const tf:TextFormat = new TextFormat("Lucida Console", SIZE, 0xFFFFFF);
        //private var timefield:TextField;
        private var timer:int, timer2:int;
        private var myTimer:Timer = new Timer(2, 0);
        
        private var hsv:ColorHSV = new ColorHSV();
        
        public function BadApplePixels()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            Security.loadPolicyFile("http://www.dreamana.com/crossdomain.xml");
            init();
        }
                
        private function init():void
        {
            //initialize 3D
            camera.x = -40;
            camera.y = -40;
            camera.z = -200;
            camera.zoom = 20;
            mode = 3;
            
            bfx = new BitmapEffectLayer(viewport, WIDTH, HEIGHT, false, 0);
            bfx.clearBeforeRender = true;
            viewport.containerSprite.addLayer( bfx );
            pixels = new Pixels( bfx );
            scene.addChild( pixels );
            
            for(var j:int=0; j < VIDEO_HEIGHT*2; ++j) {
                for(var i:int=0; i < VIDEO_WIDTH*2; ++i) {
                    var pixel:Pixel3D = new Pixel3D(0xffffff, i*2 -VIDEO_WIDTH*2, -j*2 +VIDEO_HEIGHT*2, 0);
                    pixels.addPixel3D(pixel);
                }
            }
            pixels.rotationY = 30;
                        
            //bitmap
            buffer = new BitmapData(VIDEO_WIDTH, VIDEO_HEIGHT, false, 0);
                        
            //video
            player = new VideoPlayer(VIDEO_WIDTH, VIDEO_HEIGHT);
            player.addEventListener(Event.OPEN, onOpen);
            player.addEventListener(Event.COMPLETE, onComplete);
            stream = player.play("http://www.dreamana.com/lab/badapple/BadApple.mp4");
            player.volume = 0.5;
            //addChild(player);
            
            //UI
            bar = new Sprite();
            bar.graphics.beginFill(0xffffff);
            bar.graphics.drawRect(0, 0, 1, 10);
            bar.graphics.endFill();
            bar.y = stage.stageHeight - bar.height -2;
            stage.addChild(bar);
            
            slider = new Shape();
            slider.graphics.beginFill(0);
            slider.graphics.drawRect(0, 0, 1, 4);
            slider.graphics.endFill();
            slider.y = bar.y + 3;
            stage.addChild(slider);
            
            bar.addEventListener(MouseEvent.MOUSE_DOWN, onSeek);
                                    
            status = new TextField();
            status.selectable = false;
            status.autoSize = "left";
            status.defaultTextFormat = new TextFormat("Verdana", 12, 0xffffff);
            stage.addChild(status);
            
            //timefield = new TextField();
            //timefield.defaultTextFormat = tf;
            //timefield.autoSize = "right";
            //timefield.x = stage.stageWidth-5;
            //stage.addChild(timefield);
                    
            stage.addEventListener(Event.RESIZE, onResize);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            
            player.volume = 0.5;
        }
        
        //-- video opened --
        private function onOpen(e:Event):void    
        {
            //this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            myTimer.addEventListener(TimerEvent.TIMER, onEnterFrame);
            myTimer.start();
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            var timer:Timer = new Timer(1000);
            timer.addEventListener(TimerEvent.TIMER, onTick);
            timer.start();
        }
        
        //-- video completed --
        private function onComplete(e:Event):void
        {
            if(player.meta.duration - stream.time < 2) {
                frozen = true;
                this.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
            }
        }
        
        private function addVoids(arg:uint) : uint {
            return (arg & 0xFF0000) << 8 | (arg & 0xFF00) << 4 | (arg & 0xFF);
        }
        
        private function removeVoids(arg:uint) : uint {
            return (arg & 0xFF000000) >> 8 | (arg & 0xFF000) >> 4 | (arg & 0xFF);
        }
        
        private function averageColor(arg1:uint, arg2:uint) : uint {
            return removeVoids((addVoids(arg1)+addVoids(arg2))/2);
        }
        
        //-- 3D --
        private var offset:Number = 0;
        private function onEnterFrame(e:Event):void
        {
            //timer2 = getTimer();
            //timefield.text = (timer2 - timer).toString();
            timer = timer2;
            buffer.draw( player );
            for (var no:int = 0; no < 4; ++no) {
                var n:int = (no & 1)+(no & 2)*VIDEO_WIDTH;
                for(var j:int=0; j < VIDEO_HEIGHT; ++j) {
                    for(var i:int=0; i < VIDEO_WIDTH; ++i) {
                        var c:uint = buffer.getPixel(i, j);
                        var pixel3d:Pixel3D = pixels.pixels[n];
                        if (no == 0) {                    
                            if (mode == 1) pixel3d.color = 0xFFFFFF;
                            else if (mode == 3) { hsv.h = 360*i/VIDEO_WIDTH;/*30 * (i / 120  + offset)*/; pixel3d.color = (c & hsv.value) - 0xFFFFFF; }
                            else pixel3d.color = c;
                            
                            if (mode == 0) pixel3d.z = 0;
                            else if (mode == 1) pixel3d.z = 30*(0.5-(c / 0xffffff));
                            else if (mode == 2) pixel3d.z  = Math.sin(i / 12 + offset) * 15;
                            else if (mode == 3) pixel3d.z = 0;
                        } else {
                            if ((no == 1 || j < VIDEO_HEIGHT-1) && (no == 2 || i < VIDEO_WIDTH-1)) {
                                pixel3d.color = averageColor(pixels.pixels[n-(no & 1)-(no & 2)*VIDEO_WIDTH].color, pixels.pixels[n+(no & 1)+(no & 2)*VIDEO_WIDTH].color);
                                pixel3d.z = (pixels.pixels[n-(no & 1)-(no & 2)*VIDEO_WIDTH].z + pixels.pixels[n+(no&1)+(no&2)*VIDEO_WIDTH].z) / 2;
                            } else if (j < VIDEO_HEIGHT-1) {
                                pixel3d.z = pixels.pixels[n-1].z;
                                pixel3d.color = pixels.pixels[n-1].color;
                            } else if (i < VIDEO_WIDTH-1) {
                                pixel3d.z = pixels.pixels[n-2*VIDEO_WIDTH].z;
                                pixel3d.color = pixels.pixels[n-2*VIDEO_WIDTH].color;
                            } else {
                                pixel3d.z = pixels.pixels[n-1-2*VIDEO_WIDTH].z;
                                pixel3d.color = pixels.pixels[n-1-2*VIDEO_WIDTH].color;
                            }
                        }
                        n += 2;
                    }
                    n += VIDEO_WIDTH*2;
                }
            }
            this.singleRender();
            
            if (!paused)
                offset = (offset + 0.5) % 12;
                
            timer2 = getTimer();
            //timefield.text = "Timers: "+(timer2 - timer).toString() + " (" + timefield.text + ")";
        }
        
        private var ox:int;
        private var oy:int;
        private var rx:Number;
        private var ry:Number;
        private function onMouseDown(e:MouseEvent):void
        {
            ox = mouseX;
            oy = mouseY;
            rx = pixels.rotationX;
            ry = pixels.rotationY;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        private function onMouseMove(e:Event):void
        {
            pixels.rotationY = ry + (mouseX - ox) / WIDTH * 180;
            pixels.rotationX = rx + (mouseY - oy) / HEIGHT * 180;
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
                
        //-- UI --
        private function onTick(e:Event):void
        {
            bar.scaleX = stream.bytesLoaded / stream.bytesTotal * stage.stageWidth;
            slider.scaleX = stream.time / player.meta.duration * stage.stageWidth;
        }
        
        private function onSeek(e:Event):void
        {
            var pos:Number = player.meta.duration * (stage.mouseX / stage.stageWidth);
            stream.seek(pos);
            
            if(frozen) {
                this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
                frozen = false;
            }
        }
        
        private function onResize(e:Event):void
        {
            bar.y = stage.stageHeight - bar.height - 2;
            slider.y = bar.y + 3;
        }
        
        private function onKeyDown(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.UP:
                    if(player.volume < 1) player.volume += 0.1;
                    break;
                case Keyboard.DOWN:
                    if(player.volume > 0) player.volume -= 0.1;
                    break;
                case Keyboard.RIGHT:
                    stream.seek( stream.time + 10 );
                    break;
                case Keyboard.LEFT:
                    stream.seek( stream.time - 3 );
                    break;
                case Keyboard.SPACE:
                    paused = !paused;
                    stream.togglePause();
                    break;
                case 90://Z
                    if (mode < 3) ++mode;
                    else mode = 0;
                    status.text = ["MODE: None", "MODE: Shade", "MODE: Sine", "MODE:Colorful"][mode]; 
                    break;
            }
        }
        
    }
}



import flash.display.Shape;
import flash.display.Sprite;
import flash.events.AsyncErrorEvent;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.NetStatusEvent;
import flash.media.SoundTransform;
import flash.media.Video;
import flash.net.NetConnection;
import flash.net.NetStream;

/**
 * FLV Player
 * @author civet
 */
class VideoPlayer extends Sprite
{
    public static const NO_SCALE:int = 0;
    public static const EXACT_FIT:int = 1;
    public static const MAINTAIN_ASPECT_RATIO:int = 2;
    
    public var meta:Object = {};
    private var stream:NetStream;
    private var _volume:Number = 1.0;
    private var _scaleMode:int = 0;
    private var video:Video;
    private var block:Shape;
    
    public function VideoPlayer(blockWidth:int, blockHeight:int, scaleMode:int=0)
    {
        this._scaleMode = scaleMode;
        
        block = new Shape();
        addChild(block);
        block.graphics.clear();
        block.graphics.beginFill(0);
        block.graphics.drawRect(0, 0, blockWidth, blockHeight);
        block.graphics.endFill();
        
        var nc:NetConnection = new NetConnection();
        nc.connect(null);
        stream = new NetStream(nc);
        stream.addEventListener(AsyncErrorEvent.ASYNC_ERROR, asyncErrorHandler);
        stream.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
        stream.addEventListener(NetStatusEvent.NET_STATUS, netStatusHandler);
        stream.client = this;
        
        video = new Video();
        //video.smoothing = true; //bug: [FP-178] Video.clear() fails, fp10.1 fixed
        addChild(video);
        
        video.attachNetStream(stream);
    }
            
    public function play(url:String=""):NetStream
    {
        if(url != "") {
            stream.play(url);
        }
        else {
            stream.resume();
        }
        return stream;
    }
    
    public function stop():void
    {
        stream.close();
        video.clear();
    }
    
    public function pause():void
    {
        stream.pause();
    }
    
    public function get volume():Number
    {
        return stream.soundTransform.volume;
    }
            
    public function set volume(value:Number):void
    {
        _volume = value;
        
        var t:SoundTransform = stream.soundTransform;
        t.volume = _volume;
        stream.soundTransform = t;
    }
                    
    private function resizeVideo(videoWidth:int, videoHeight:int):void
    {
        if(video.videoWidth != 0) videoWidth = video.videoWidth;
        if(video.videoHeight != 0) videoHeight = video.videoHeight;
        var w:Number;
        var h:Number;
        if(_scaleMode == NO_SCALE) {
            w = videoWidth;
            h = videoHeight;
            video.width = w;
            video.height = h;
            video.x = int((block.width - w) /2) + block.x;
            video.y = int((block.height - h) /2) + block.y;
        }
        else if(_scaleMode == EXACT_FIT) {
            video.width = block.width;
            video.height = block.height;
            video.x = block.x;
            video.y = block.y;
        }
        else if(_scaleMode == MAINTAIN_ASPECT_RATIO) {
            w = (videoWidth / videoHeight) * block.height;
            h = block.height;
            if(w > block.width) {
                w = block.width;
                h = (videoHeight / videoWidth) * block.width;
            }
            video.width = w;
            video.height = h;
            video.x = int((block.width - w) /2) + block.x;
            video.y = int((block.height - h) /2) + block.y;
        }
        
        this.dispatchEvent(new Event(Event.RESIZE));
    }
        
    private function asyncErrorHandler(e:AsyncErrorEvent):void {
        //ignore error
    }
    
    private function ioErrorHandler(e:IOErrorEvent):void {
        trace(e.text);
    }
    
    private function netStatusHandler(e:NetStatusEvent):void
    {
        switch(e.info.code) {
            case "NetStream.Play.Stop":
                dispatchEvent(new Event(Event.COMPLETE));
                break;
            case "NetStream.Play.Start":
                dispatchEvent(new Event(Event.OPEN));            
                break;
        }
    }
    
    /* NetStream client Event Hanlders */
    public function onMetaData(info:Object):void {
            //trace("metadata: duration=" + info.duration + " width=" + info.width + " height=" + info.height + " framerate=" + info.framerate);
        meta = info;
            resizeVideo(info.width, info.height);
    }
    
    public function onCuePoint(info:Object):void {
            //trace("cuepoint: time=" + info.time + " name=" + info.name + " type=" + info.type);
    }
    
}
