/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7DsF
 */

//色って難しい
//もうわけかわらん状態
//pixelでどうにかして

package 
{
    import com.bit101.charts.LineChart;
    import com.bit101.components.Label;
    import com.bit101.components.VBox;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import org.papervision3d.core.effects.BitmapLayerEffect;
    import org.papervision3d.core.effects.utils.BitmapDrawCommand;
    import org.papervision3d.core.geom.Pixels
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.materials.BitmapColorMaterial;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    
    
    [SWF(width=465,height=465,backgroundColor=0x000000)]
    [SWF(width=465,height=465)]
    //public class Main extends BasicView
    public class Soundtest8 extends BasicView
    {
        private var NUM:int = 256;
        private var rot:Number = 0;
        
        private var snd:Sound;
        private var sndChannel:SoundChannel;
        
        private var LRarr:Array = [];
        
        private var FFTswitcher:Boolean = false;
        private var matrix:Matrix;
        private var canvas:Bitmap;
        private var bmpData:BitmapData;
        private var lineChart:LineChart;
        private var arrayLineChart:Array;
        private var lineChart2:LineChart;
        private var arrayLineChart2:Array;
        
        
        //public function Main():void 
        public function Soundtest8() 
        {
            //Wonderfl.capture_delay(2);
            playSound("http://www.takasumi-nagai.com/soundfiles/sound001.mp3");
            camera.zoom = 2 ;
        }
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, onComp);
        }
        
        private function onComp(e:Event):void 
        {
            //graphics.beginFill(0x000000);
            //graphics.drawRect(0, 0, 465, 465);
            //graphics.endFill();
            
            sndChannel=new SoundChannel();
            sndChannel = snd.play(0, 5);
            LRarr = init3D();
            startRendering();
            addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(MouseEvent.CLICK, FFTSwitch);
            bmpData = new BitmapData(465 / 4, 465 / 4, false, 0x000000);
            canvas = new Bitmap(bmpData, "never", true);
            //canvas.scaleX = canvas.scaleY = 4;
            canvas.smoothing = true;
            canvas.blendMode = BlendMode.ADD;
            addChild(canvas);
            matrix = new Matrix(0.25, 0, 0, 0.25);
            var vBox:VBox = new VBox(this, 10, 310);
            new Label(vBox, 0, 0, 'camera.zoom');
            lineChart = new LineChart(vBox, 10, 410, []);
            lineChart.setSize(lineChart.width, 50);
            lineChart.maximum = 50;
            lineChart.autoScale = false;
            new Label(vBox, 0, 0, 'rot');
            lineChart2 = new LineChart(vBox, 10, 410, []);
            lineChart2.setSize(lineChart.width, 50);
            lineChart2.maximum = 50;
            //lineChart2.autoScale = false;
            arrayLineChart = [];
            arrayLineChart2 = [];
        }
        
        private function FFTSwitch(e:MouseEvent):void 
        {
            if (FFTswitcher) { FFTswitcher = false } else { FFTswitcher = true; }
        }
        
        private function loop(event:Event):void 
        {
            var px:Pixel3D;
            bmpData.fillRect(bmpData.rect, 0x000000);
            bmpData.draw(viewport, matrix);
            
            rot += 1%360;
            
            camera.x = 500 * Math.sin(rot * Math.PI / 180);
            camera.z = 500 * Math.cos(rot * Math.PI / 180);
            camera.y = 500 * Math.cos(rot * Math.PI / 180);
            camera.zoom += ( 50 - camera.zoom) / 10;
            
            arrayLineChart[arrayLineChart.length] = camera.zoom;
            lineChart.data = arrayLineChart;
            if (lineChart.data.length > 200) lineChart.data.shift();
            
            arrayLineChart2[arrayLineChart2.length] = rot;
            lineChart2.data = arrayLineChart2;
            if (lineChart2.data.length > 200) lineChart2.data.shift();
            //trace( "camera.zoom : " + camera.zoom );
            
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, FFTswitcher, 0);
            var isInRange:Boolean;
            var isInRangeCount:int;
            for (var n:int = 0; n < 2; n++)
            {
                var soundArray:Array = LRarr[n];
                for (var i:int = 0; i < 256; i++)
                {
                    px = new Pixel3D(0xFF000000);
                    px = soundArray[i];
                    var data:Number = bytes.readFloat();
                    
                    if (i == 0)
                    {
                        if (data>0.35)
                        {
                            camera.zoom = 0;
                            trace(data.toFixed(4));
                        }
                    }
                    
                    if (10 < i <50)
                    {
                        if (data>0.3)
                        {
                            rot += 10;
                            //bmpData.colorTransform(bmpData.rect, new ColorTransform(1, 1, 1, 1, 1, 0, 0, 0));
                            if (n == 0) 
                            {
                                isInRangeCount++;
                                isInRange = true;
                            }
                        }
                    }
                }
            }
            if(isInRange)trace( "isInRangeCount : " + isInRangeCount );
        }
        
        private function init3D():Array
        {
            var pixelCOlor:uint = 0xFF000000;
            var pixelCOlor2:uint = 0xFFff0000;
            var master_arr:Array = [];
            
            var _effect:BitmapEffectLayer = new BitmapEffectLayer(viewport, 465, 465);
            _effect.addEffect(new BitmapLayerEffect(new BlurFilter(2, 3, 1)));
            
            _effect.drawCommand = new BitmapDrawCommand(null, null, BlendMode.ADD);
            viewport.containerSprite.addLayer(_effect);
            
            var pxs:Pixels = new Pixels(_effect);
            scene.addChild(pxs);
            
            for (var n:int = 0; n < 2; n++)
            {
                var lr_arr:Array = [];
                for (var i:int = 0; i < NUM; i++)
                {
                    var xx:Number = Math.random() * 1000 - 500;
                    var yy:Number = Math.random() * 1000 - 500;
                    var zz:Number = Math.random() * 1000 - 500;
                    
                    if (n == 0)
                    {
                        var px01:Pixel3D = new Pixel3D(pixelCOlor, xx, yy, zz);
                        pxs.addPixel3D(px01);
                        lr_arr.push(px01);
                    }
                    else
                    {
                        var px02:Pixel3D = new Pixel3D(pixelCOlor2, xx, yy, zz);
                        //var px02:Pixel3D = new Pixel3D(0xFFff00ff, xx, yy, zz);
                        pxs.addPixel3D(px02);
                        lr_arr.push(px02);
                    }
                }
                master_arr.push(lr_arr);
            }
            return master_arr;
        }
        
    }
    
}