/**
 * Copyright curvedstraightline ( http://wonderfl.net/user/curvedstraightline )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7COO
 */

package  {
	
	import flash.display.*;
	import flash.events.*;
	
	//[SWF(width="300", height="300", backgroundColor="#FFFFFF", frameRate="30")]
	
	public class ParticleTest extends Sprite {
		public var WIDTH:uint = stage.stageWidth;
		public var HEIGHT:uint = stage.stageHeight;
		public var len:uint = 300;
		public var pList:Array = [];
		public var canvas:BitmapData;
		public var _sp:Shape;
		
		public function ParticleTest() {
			// constructor code
			if(stage) init();
			else this.addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init (e:Event=null):void {
			canvas = new BitmapData(WIDTH, HEIGHT, false, 0x00000000);
			addChild(new Bitmap(canvas));
			for (var i:uint = 0 ; i<len ; i++){
				var particle:Particle = new Particle();
				particle.x = rand(WIDTH);
				particle.y = rand(HEIGHT);
				particle.vx = rand(1)*10-5;
				particle.vy = rand(1)*10-5;
				particle.col = rand(0xFFFFFF);
				pList.push(particle);
			}
			this.addEventListener(Event.ENTER_FRAME, enterframeHandler);
			//drawCircle();
		}
		
		private function enterframeHandler (e:Event):void {
			canvas.fillRect(canvas.rect,0x00000000);
			for (var i:uint = 0 ; i<len ; i++){
				var pt:Particle = pList[i];
				pt.x+=pt.vx;
				pt.y+=pt.vy;
				if(pt.x <0) pt.x=WIDTH;
				if(pt.x >WIDTH) pt.x=0;
				if(pt.y <0) pt.y=HEIGHT;
				if(pt.y >HEIGHT) pt.y=0;
				//var c:circle = new circle(pt.x,pt.y,10,pt.color);
				//canvas.draw(c);
				_sp = new Shape();
				_sp.graphics.beginFill(pt.col);
				_sp.graphics.drawCircle(pt.x,pt.y,10);
				_sp.graphics.endFill();
				canvas.draw(_sp);
				//canvas.setPixel(pt.x,pt.y,pt.col);
			}
		}
		
		/*private function drawCircle(x:Number,y:Number,radius:Number,color:Number):void{
			_sp = new Shape();
			_sp.graphics.beginFill(0xff0000);
			_sp.graphics.drawCircle(10,10,10);
			_sp.graphics.endFill();
			canvas.draw(_sp);
		}*/
		
		private function rand(num:Number):Number {
			return Math.random()*num;
		}
	}
}


class Particle {
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var col:uint;
}
