/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7C4o
 */

package {
    import flash.display.*;
    import flash.events.*;
    public class FlashTest extends Sprite {
        
        //------定数---------
        
        private const WALL_L :Number = 50;
        private const WALL_R :Number = 400;
        private const FLOOR :Number = 400;
        private const HANSYA :Number = -0.8;
        private const GRAVITY :Number = 1;
        
        private const MOUSE_POWER :Number = 20;
        
        //-----変数--------
        
        private var ball :Sprite;
        private var ballSpeedX :Number;
        private var ballSpeedY :Number;
        
        //--------------
        
        public function FlashTest() {
            ballSpeedX = 0;
            ballSpeedY = 0;
            ball = createCircle(20, 0x990000);
            ball.x = 200;
            ball.y = 200;
            addChild(ball);
            addEventListener(Event.ENTER_FRAME, update);
        }
        private function update(ev:Event = null) :void{
            
            //マウスに近づきすぎると反発
            var kyoriX :Number = ball.x - mouseX;
            var kyoriY :Number = ball.y - mouseY;
            if(Math.abs(kyoriX) < MOUSE_POWER && Math.abs(kyoriY) < MOUSE_POWER){
                if(Math.abs(kyoriX) < MOUSE_POWER){
                    ballSpeedX += kyoriX;
                }
                if(Math.abs(kyoriY) < MOUSE_POWER){
                    ballSpeedY += kyoriY;
                }
            }
            
            //常に下向きに重力
            ballSpeedY += GRAVITY;
            
            //ボールの動き
            ball.x += ballSpeedX;
            ball.y += ballSpeedY;
            
            //壁や床にぶつかると勢いを殺しながら反射。
            if(ball.x < WALL_L){
                ball.x = WALL_L;
                ballSpeedX *= HANSYA;
            }else if(ball.x > WALL_R){
                ball.x = WALL_R;
                ballSpeedX *= HANSYA;
            }
            if(ball.y > FLOOR){
                ball.y = FLOOR;
                ballSpeedY *= HANSYA;
            }
            
        }

        
        private function createCircle(hankei :Number, color :int) :Sprite{
            var sp :Sprite = new Sprite();
            var gra :Graphics = sp.graphics;
            gra.beginFill(color, 1);
            gra.drawCircle(0,0,hankei);
            gra.endFill();
            return sp;
        }

    }
}