/**
 * Copyright amakawa ( http://wonderfl.net/user/amakawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/7BqQ
 */

// forked from mousepancyo's フォント共有テスト（Dynamic Embedded Fonts）
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.events.MouseEvent;
    import flash.text.TextFormat;
    import flash.system.Security;
    import com.bit101.components.*;

    public class FontEmbedTest extends Sprite {
        
        private var tx1:TextField = new TextField() 
        private var tx2:TextField = new TextField() 
        private var _Stencil:FontEmbed;
        private var _HiraginoKaku:FontEmbed;        
        private var _txtFmt:TextFormat = new TextFormat()
        
        private var _bar:ProgressBar;
        private var _label:Label;

        public function FontEmbedTest() {
            _label = new Label(this, 180, 203, "Now Loading");
            _bar = new ProgressBar(this, 180, 220);
            _bar.maximum = 100;
            _bar.addEventListener(Event.ENTER_FRAME, loading);
            
            tx1.x = 30
            tx1.y = 50
            tx1.rotation = -5
            tx2.x = 50
            tx2.y = 150
            tx2. rotation = 20
            tx1.defaultTextFormat = tx2.defaultTextFormat = _txtFmt
            
            addChild(tx1)
            addChild(tx2)
            
            //Load Stencil
            _Stencil = new FontEmbed("http://www.digifie.jp/files/Stencil.swf", "Stencil");
           
            //Load Hiragino Kaku Gothic Pro W6
            _HiraginoKaku = new FontEmbed("http://www.digifie.jp/files/HiraginoKakuW6.swf", "HirakakuW6");
            _HiraginoKaku.addEventListener(FontEmbed.FONT_LOADED, onFontLoaded);
        }
        
        private function loading(event:Event):void {
            _bar.value = _HiraginoKaku.progress;
            if(_bar.value >= 100){
                _bar.removeEventListener(Event.ENTER_FRAME, loading);
                removeChild(_bar)
                removeChild(_label)
            }
        }

        private function onFontLoaded(e:Event):void {
            
            //Embeted Stencil
            _Stencil.embetedFont(tx1, "Stencil", 48, _txtFmt);
            //_Stencil.removeEventListener(FontEmbed.FONT_LOADED, onFontLoaded);
            
            //Embeted Hiragino Kaku Gothic Pro W6
            _HiraginoKaku.embetedFont(tx2, "Hiragino Kaku Gothic Pro W6", 18, _txtFmt);
            _HiraginoKaku.removeEventListener(FontEmbed.FONT_LOADED, onFontLoaded);
            
            //Test
            tx1.autoSize = tx2.autoSize = "left";
            tx1.text = "Font : Stencil\nHello Wonderfl";
            tx2.text = "Font : Hiragino Kaku Gothic Pro W6\n\n日本語フォントも無事埋め込めました。\n回転させても文字が消えません。\n\n「朧、卍、犧、巛、个、嚶、网、挈、儁、潺、鼈」など、\n読み方も分からないような漢字も表示できています。\n\nあ、卍は「卍固め」のまんじでしたね。";
        }
    }
}


//class FontEnbed
import flash.events.Event;
import flash.events.ProgressEvent;
import flash.events.EventDispatcher;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.net.URLLoader;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.Font;
import flash.system.LoaderContext;
import flash.system.ApplicationDomain;
import flash.system.SecurityDomain;
import flash.system.Security;

class FontEmbed extends EventDispatcher {

    private var _fontClassName:String
    private var _loader:Loader = new Loader()
    public var progress:int
    
    public static const FONT_LOADED:String = "font_loaded";
    
    public function FontEmbed(fontPath:String, fontClassName:String) {
        Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
        Security.allowDomain("www.digifie.jp");
        swfLoad(fontPath);
        _fontClassName = fontClassName;
    }
    
    //Load FontSwf
    private function swfLoad(fontPath:String):void{
        var context:LoaderContext = new LoaderContext(); 
        context.checkPolicyFile = true;
        context.securityDomain = SecurityDomain.currentDomain; 
        context.applicationDomain = ApplicationDomain.currentDomain;
        var req:URLRequest = new URLRequest(fontPath);
        _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, swfLoadComplete);
        _loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS,onProgressListener);
        _loader.load(req, context);
    }
    
    //Progress
    private function onProgressListener(e:ProgressEvent):void {
        progress = e.bytesLoaded/e.bytesTotal*100;
    }
    
    //Load Complete
    private function swfLoadComplete(e:Event):void {
        _loader.contentLoaderInfo.removeEventListener(Event.COMPLETE,swfLoadComplete);
        _loader.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS,onProgressListener);
        var fontClass:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition(_fontClassName) as Class; 
        try{
            Font.registerFont(fontClass);
        }catch(e:Error){
            //
        }
        dispatchEvent(new Event(FontEmbed.FONT_LOADED));
    }
    
    //Embeted Font
    public function embetedFont(txt:TextField, fontname:String, size:Number, fmt:TextFormat):void {
        var tfmt:TextFormat = fmt
        tfmt.font = fontname;
        tfmt.size = size;
        txt.embedFonts = true;
        txt.defaultTextFormat = tfmt;
    }
}