/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/79fE
 */

// forked from uwi's SiON ROKUON
// SiONで再生したMMLをwavファイルにして保存するよ
// thanks @sakef
// @see http://sakef.jp/blog/2010/08/microphone_record02/
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.*;
    import flash.media.*;
    import flash.utils.*;
    import flash.net.*;
    import org.si.sion.*;
    import org.si.sion.events.*;
    import com.bit101.components.*;
    import org.si.sion.utils.SiONPresetVoice;

    public class Test extends Sprite {
        private var _tf : TextField;
        private var _driver : SiONDriver;
        private var _play : PushButton;
        private var _save : PushButton;
        private var _data : ByteArray;
        private var _wav : ByteArray;
        private var _mml : TextArea;
        private var _filename : InputText;
        private var _pv : SiONPresetVoice;
        private var _cb : ComboBox;

        public function Test() {
            _tf = new TextField();
            _tf.width = 100;
            _tf.height = 100;
            addChild(_tf);
            
            _pv = new SiONPresetVoice();
            var a : Array = [];
            for(var key : String in _pv){
                a.push(key);
            }
            a.sort();
            
            _mml = new TextArea(this, 50, 50, "%5@34t140l4c*<c*>c*<c*>c*<c*>c*<c*>c;\r%5@34t140l4e*<e*>e*<e*>e*<e*>e*<e*>e;");
            _mml.width = 365;
            _mml.height = 200;
            
            new Label(this, 50, 270, "%6@00");
            _cb = new ComboBox(this, 130, 270, "default", a);

            new Label(this, 50, 300, "filename to save");
            _filename = new InputText(this, 130, 300, "rec.wav");
            _filename.width = 285;
            _filename.textField.restrict = "^/\\:\*\?\"<>\|%";
            
            _play = new PushButton(this, 100, 350, "Play", onPlay);
            _save = new PushButton(this, 260, 350, "Save", onSave);
           
            _driver = new SiONDriver();
            _driver.addEventListener(SiONEvent.FINISH_SEQUENCE, onFinishSequence);
  
            _save.enabled = false;
        }
        
        public function onPlay(e:MouseEvent) : void
        {
            _driver.addEventListener(SiONEvent.STREAM, onStream);
            _data = new ByteArray();
            _data.endian = Endian.LITTLE_ENDIAN;
            if(_cb.selectedItem)_driver.setVoice(0, _pv[_cb.selectedItem]);
            _driver.play(_mml.text);
            _save.enabled = false;
        }
        
        public function onFinishSequence(e:SiONEvent) : void {
            _driver.removeEventListener(SiONEvent.STREAM, onStream);
//            _driver.removeEventListener(SiONEvent.FINISH_SEQUENCE, onFinishSequence);
            _wav = new ByteArray();
            _wav.endian = Endian.LITTLE_ENDIAN;
            _wav.writeUTFBytes("RIFF");
            var len : int = _data.length;
            _wav.writeInt(len + 36);
            _wav.writeUTFBytes("WAVE");
            _wav.writeUTFBytes("fmt ");
            _wav.writeInt(16);
            _wav.writeShort(1);
            _wav.writeShort(2);
            _wav.writeInt(44100);
            _wav.writeInt(176400);
            _wav.writeShort(4);
            _wav.writeShort(16);
            _wav.writeUTFBytes("data");
            _wav.writeInt(len);
            _data.position = 0;
            _wav.writeBytes(_data);
            
            _save.enabled = true;
        }
        
        private function onStream(e : SiONEvent) : void
        {
            e.streamBuffer.position = 0;
            while(e.streamBuffer.bytesAvailable > 0){
                var d : int = e.streamBuffer.readFloat() * 32767;
                _data.writeShort(d);
            }
        }
        
        private function onSave(e : MouseEvent) : void
        {
            if(_wav){
                var fr : FileReference = new FileReference();
                fr.save(_wav, _filename.text);
            }
        }

        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
        }
    }
}