/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/79eR
 */

// forked from paq's [QuickBox2D] Doll
package 
{
	import Box2D.Common.Math.b2Vec2;
	import Box2D.Dynamics.Joints.b2RevoluteJoint;
	import com.actionsnippet.qbox.QuickBox2D;
	import com.actionsnippet.qbox.QuickObject;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * 立てません＞＜
	 * @author paq89
	 */
	[SWF(width = 465, height = 465, backgroundColor = 0x333333, frameRate = 60)]
	public class Main extends MovieClip 
	{
		private static const DRAW_SCALE:Number = 30;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			var sim:QuickBox2D = new QuickBox2D(this);
			sim.setDefault({fillColor:0x288CC, fillAlpha:0.8, lineColor:0x995B5C9});
			sim.createStageWalls();
			
			var head:QuickObject = sim.addCircle( { x:232 / DRAW_SCALE, y:4 / DRAW_SCALE, radius:17 / DRAW_SCALE } );
			var torsoA:QuickObject = sim.addBox( { x:232 / DRAW_SCALE, y:35 / DRAW_SCALE, width:53 / DRAW_SCALE, height:28 / DRAW_SCALE, restitution:0.9 } );
			var torsoB:QuickObject = sim.addBox( { x:232 / DRAW_SCALE, y:55 / DRAW_SCALE, width:45 / DRAW_SCALE, height:28 / DRAW_SCALE, restitution:5 } );
			var torsoC:QuickObject = sim.addBox( { x:232 / DRAW_SCALE, y:75 / DRAW_SCALE, width:40 / DRAW_SCALE, height:28 / DRAW_SCALE, restitution:0.9 } );
			var pelvis:QuickObject = sim.addBox( { x:232 / DRAW_SCALE, y:95 / DRAW_SCALE, width:45 / DRAW_SCALE, height:25 / DRAW_SCALE, restitution:0.9 } );
			var leftArmA:QuickObject = sim.addBox( { x:185 / DRAW_SCALE, y:28 / DRAW_SCALE, width:50 / DRAW_SCALE, height:15 / DRAW_SCALE } );
			var leftArmB:QuickObject = sim.addBox( { x:135 / DRAW_SCALE, y:28 / DRAW_SCALE, width:50 / DRAW_SCALE, height:15 / DRAW_SCALE, restitution:1 } );
			var rightArmA:QuickObject = sim.addBox( { x:280 / DRAW_SCALE, y:28 / DRAW_SCALE, width:50 / DRAW_SCALE, height:15 / DRAW_SCALE } );
			var rightArmB:QuickObject = sim.addBox( { x:330 / DRAW_SCALE, y:28 / DRAW_SCALE, width:50 / DRAW_SCALE, height:15 / DRAW_SCALE, restitution:1 } );
			var leftLegA:QuickObject = sim.addBox( { x:217 / DRAW_SCALE, y:132 / DRAW_SCALE, width:16 / DRAW_SCALE, height:55 / DRAW_SCALE, restitution:2 } );
			var leftLegB:QuickObject = sim.addBox( { x:246 / DRAW_SCALE, y:132 / DRAW_SCALE, width:16 / DRAW_SCALE, height:55 / DRAW_SCALE, restitution:2 } );
			var rightLegA:QuickObject = sim.addBox( { x:217 / DRAW_SCALE, y:185 / DRAW_SCALE, width:16 / DRAW_SCALE, height:55 / DRAW_SCALE, restitution:2 } );
			var rightLegB:QuickObject = sim.addBox( { x:246 / DRAW_SCALE, y:185 / DRAW_SCALE, width:16 / DRAW_SCALE, height:55 / DRAW_SCALE, restitution:2 } );
			
			var anchor:QuickObject = sim.addCircle({x:232 / DRAW_SCALE, y:0/DRAW_SCALE, density:0, radius:0.1, fillAlpha:0, lineAlpha:0 });
			sim.addJoint( { a:head.body, b:anchor.body, length:250 / DRAW_SCALE, dampingRatio:0.06, lineAlpha:0 } );

			sim.setDefault( { type:"revolute", collideConnected:false, enableLimit:true, lineColor:0xFFFFFF } );
			sim.addJoint( { a:head.body, b:torsoA.body, lowerAngle:-0.2, upperAngle:0.2 } );
			sim.addJoint( { a:torsoA.body, b:torsoB.body, lowerAngle:-0.2, upperAngle:0.2 } );
			sim.addJoint( { a:torsoB.body, b:torsoC.body, lowerAngle:-0.2, upperAngle:0.2 } );
			sim.addJoint( { a:torsoC.body, b:pelvis.body, lowerAngle:-0.2, upperAngle:0.2 } );
			sim.addJoint( { a:torsoA.body, b:leftArmA.body, x1:212 / DRAW_SCALE, y1:DRAW_SCALE / DRAW_SCALE, lowerAngle:-2, upperAngle:1} );
			sim.addJoint( { a:leftArmA.body, b:leftArmB.body, x1:155 / DRAW_SCALE, y1:28 / DRAW_SCALE, lowerAngle: -2, upperAngle:1 } );
			sim.addJoint( { a:torsoA.body, b:rightArmA.body, x1:257 / DRAW_SCALE, y1:28 / DRAW_SCALE, lowerAngle:-1, upperAngle:2} );
			sim.addJoint( { a:rightArmA.body, b:rightArmB.body, x1:314 / DRAW_SCALE, y1:28 / DRAW_SCALE, lowerAngle: -1, upperAngle:2 } );
			sim.addJoint( { a:pelvis.body, b:leftLegA.body, x1:217 / DRAW_SCALE, y1:110 / DRAW_SCALE, lowerAngle: -1, upperAngle:1 } );
			sim.addJoint( { a:pelvis.body, b:leftLegB.body, x1:246 / DRAW_SCALE, y1:110 / DRAW_SCALE, lowerAngle: -1, upperAngle:1 } );
			sim.addJoint( { a:leftLegA.body, b:rightLegA.body, x1:217 / DRAW_SCALE, y1:163 / DRAW_SCALE, lowerAngle: -1, upperAngle:1 } );
			sim.addJoint( { a:leftLegB.body, b:rightLegB.body, x1:246 / DRAW_SCALE, y1:163 / DRAW_SCALE, lowerAngle: -1, upperAngle:1 } );
			
			sim.start();
			sim.mouseDrag();
		}
		
	}
	
}