/**
 * Copyright yprops ( http://wonderfl.net/user/yprops )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/79Wt
 */

// forked from yprops's DebugText
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    public class DebugText extends Sprite {
        public function DebugText() {
            addDeb(450, 450);
            
            //本文
            addDebLine("\n-----------------------\nint型 → ビット");
            outputInt2bit(0);
            outputInt2bit(1);
            outputInt2bit(-1);
            outputInt2bit(255);
            
            addDebLine("\n-----------------------\nビット → int型");
            outputBit2int("001");
            outputBit2int("10000000000000000000000000000000");
            outputBit2int("01111111111111111111111111111111");
         }
        
        
        //----------------------------
        
        private function outputInt2bit(n :int) :void{
            addDebLine("\n[int " + n + "]\n[bit " + int2bit(n) + "]");
        }
        private function int2bit(n :int) :String{
            var i :int;
            var s :String = "";
            for(i = 0; i < 32; i++){
                s = ((n & 1 << i)? "1" : "0") + ((!i || i%4)?"":" ") + s;
            }
            return s;
        }
        
        private function outputBit2int(t :String) :void{
            var n :int = bit2int(t);
            addDebLine("\n[bit " + int2bit(n) + "]\n[int " + n + "]");
        }
        /// @param s 0101...などの文字列。右から32文字を使用。1はtrue, それ以外はfalseとする。
        private function bit2int(t :String) :int{
            var i :int;
            var n :int = 0;
            var s :String = "";
            for(i = 0; i < 32; i++){
                n |= int(t.charAt(t.length - 1 - i) == "1") << i;
            }
            return n;
        }
        
        
        //-------------------------------
        private var deb :TextField;
        private function addDeb(w:uint, h:uint) :void{
                deb = new TextField();
                deb.wordWrap = true;
                deb.width = w;
                deb.height = h;
                deb.border = true;
                deb.borderColor = 0;
                deb.background = true;
                deb.backgroundColor = 0x99ffffff;
                deb.text = "beginDebugText-------\n";
                addChild(deb);
        }
        private function addDebLine(str :String) :void{
                deb.appendText(str + "\n");
                deb.scrollV = deb.maxScrollV;
        }
    }
}