/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/79Pt
 */

// forked from siouxcitizen's 某鋼板は256回攻撃しても破壊できないので避けてください
// forked from heart_thai's Roku Shooting Version
// forked from buccchi's オッス、おらロク！（墨エフェクト）
// forked from buccchi's オッス、おらロク！
//今度は鋼板破壊できるようにしてみました
//
//使用3Dモデルを、DAEモデルからPrimitiveオブジェクト(PaperPlane)に変更して当たり判定等追加してみました。
//↑複雑なDAEモデルのうまい当たり判定がよくわからないため。。。
//今度はPaperPlaneの表示がなにか変ですが。。。
//
//操作方法
//・マウス左右操作で操作PaperPlaneオブジェクとが左右に移動
//・左クリック押下で攻撃弾発射
//攻撃弾で鋼板を破壊？する毎にSCOREに100ポイント加算となります
//操作PaperPlaneオブジェクがhitTestObject()による当たり判定で鋼板と衝突するとゲームオーバーとなります
//
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    import flash.utils.Timer;
    import net.hires.debug.Stats;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.PaperPlane;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.lights.PointLight3D;
    import flash.text.*;
    public class FlashTest extends Sprite {
        private var mountens:Vector.<DAE>;
        private var steelPlates:Vector.<Cube>;
        private var powers:Vector.<Sphere>
        private var player:PaperPlane;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var vp:Viewport3D;
        private var rd:BasicRenderEngine;
        private var tm:Timer;
        private var gameOver:Boolean = false;
        private var light:PointLight3D;
        private var flatShadeMate:FlatShadeMaterial;
        private var materials:MaterialsList;
        private var score:int = 0;
        private const PLATE_SIZE : int = 120; //鋼板Cubeの一辺のサイズ
        private const PLATE_THICK : int = 5; //鋼板Cubeの厚さ

        private var scoreTxt : TextField;//スコアテキスト
        private var scoreTxtFormat : TextFormat;//スコアテキストフォーマット
        private var gameOverTxt : TextField;//「ゲームオーバー」表示テキスト
        private var gameOverTxtFormat : TextFormat;//「ゲームオーバー」表示テキストフォーマット
        public function FlashTest():void {
            addChild( new Stats() );
            scene = new Scene3D();
            camera = new Camera3D();
            rd = new BasicRenderEngine();
            vp = new Viewport3D(stage.stageWidth , stage.stageHeight );
            addChild(vp);
            camera.zoom = 50;
            
            //スコア文字列設定
            scoreTxt = new TextField;
            scoreTxt.text = "ButtonTest!";
            scoreTxt.x = 370;
            scoreTxt.y = 10;
            scoreTxt.width = 100;
            scoreTxt.multiline = true;
            scoreTxt.text = "SCORE: " + score;
            addChild(scoreTxt); 
            //スコア字列用フォーマット設定(デフォルト設定)
            //scoreTxtFormat = new TextFormat();
            //scoreTxtFormat.font = "Courier New";
            //scoreTxtFormat.bold = true;
            //scoreTxtFormat.size = 13;
            //scoreTxt.setTextFormat(scoreTxtFormat);
            //「GAME OVER」文字列設定
            gameOverTxt = new TextField;
            gameOverTxt.x = 55;
            gameOverTxt.y = 170;
            gameOverTxt.width = 400;
            gameOverTxt.height = 200;
            gameOverTxt.multiline = false;
            gameOverTxt.text = "GAME OVER";           
            //addChild(gameOverTxt);  
            //「GAME OVER」字列用フォーマット設定
            gameOverTxtFormat = new TextFormat();
            gameOverTxtFormat.font = "Courier New";
            gameOverTxtFormat.bold = true;
            gameOverTxtFormat.size = 70;
            gameOverTxt.setTextFormat(gameOverTxtFormat);

            //光源設定
            light = new PointLight3D();
            light.y = -8000;
            light.x = -8000;
            light.z = -8000;
            //鋼板用マテリアル設定
            flatShadeMate = new FlatShadeMaterial(light, 0xdddddd, 0x555555);
            flatShadeMate.doubleSided = true;
            materials = new MaterialsList(
                {front:flatShadeMate,back:flatShadeMate,right:flatShadeMate,left:flatShadeMate,top:flatShadeMate,bottom:flatShadeMate});

            createMouten();
            createSteelPlate();
            createPlayer();
            
            camera.y = 100; 
            
            powers = new Vector.<Sphere>();
            tm = new Timer(200);
            tm.addEventListener(TimerEvent.TIMER , shotting );
            
            this.addEventListener(Event.ENTER_FRAME , loop);
            stage.addEventListener(MouseEvent.MOUSE_DOWN , shot );
            stage.addEventListener(MouseEvent.MOUSE_UP , stopShot );
        }
        private function shot(e:MouseEvent):void {
            tm.start();
        }
        private function stopShot(e:MouseEvent):void {
            tm.stop();
        }
        private function shotting(e:TimerEvent):void {    
            var c:ColorMaterial = new ColorMaterial(0xFF0000,0.5);
            var p:Sphere = new Sphere( c , 50 );
            p.x = player.x;
            p.y = player.y;
            p.z = player.z
            scene.addChild(p);
            powers.push(p);
        }
        private function createMouten():void {
            mountens = new Vector.<DAE>();
            for(var i:int = 0 ; i<=20 ; i++){
                var mountain:DAE = new DAE();
                mountain.load("http://7980.oui-imja.com/wonderfl/201002/mountain.dae");
                scene.addChild(mountain); 
                mountain.y = -100;
                mountain.scale = 10;
                mountain.x = 1000-(Math.random()*2000);
                mountain.z = 1000 - (Math.random() * 2000);
                mountens.push(mountain);
            }
                    
        }
        private function createSteelPlate():void {
            steelPlates = new Vector.<Cube>();
            for(var i:int = 0 ; i<=1 ; i++){
                var steelPlate:Cube = new Cube(materials,PLATE_SIZE,PLATE_THICK,PLATE_SIZE,1,1,1);
                scene.addChild(steelPlate); 
                steelPlate.y = 100;
                steelPlate.x = 1000-(Math.random()*2000);
                steelPlate.z = 1000 - (Math.random() * 2000);
                steelPlates.push(steelPlate);
            }
        }
        private function createPlayer():void{
            //var c:ColorMaterial = new ColorMaterial(0x0000FF, 0.7);
            var w:WireframeMaterial = new WireframeMaterial(0xFF0000);
            player= new PaperPlane(w);
            player.scale = 1.5;
            player.y = 50;
            player.z = -500;
            scene.addChild(player);
        }
        private function loop(event:Event):void {
            if(gameOver){return;} //ゲームオーバー時は処理をストップ
            var sx:Number = (mouseX-(stage.stageWidth/2)) - player.x;
            player.x += sx/10;
            for (var i:String in mountens) {
                mountens[i].z -= 50;
                if (mountens[i].z < -1000) {
                    mountens[i].z = 1000;
                    mountens[i].x = 1000-(Math.random()*2000);
                }
            }
            for (var j:uint=0;j<powers.length;j++){
                powers[j].z += 150;
                if (powers[j].z > 5000) {
                    scene.removeChild(powers[j]);
                    powers.splice(int(j), 1);
                }
                for (var k:uint=0;k<steelPlates.length;k++){
                    if(powers[j].hitTestObject(steelPlates[k])) {
                        scene.removeChild(powers[j]);
                        powers.splice(int(j), 1);
                        steelPlates[k].z = 1000;
                        steelPlates[k].x = 1000-(Math.random()*2000);
                        score++;
                        scoreTxt.text = "SCORE: " + (score*100);  
                    }
                }
            }
            for (i in steelPlates) {
                steelPlates[i].z -= 50;
                steelPlates[i].rotationX -= 20;
                if (player.hitTestObject(steelPlates[i])) {
                    gameOver = true;
                    addChild(gameOverTxt);//「GAME OVER」文字列表示
                    return;
                }
                if (steelPlates[i].z < -1000) {
                    steelPlates[i].z = 1000;
                    steelPlates[i].x = 1000-(Math.random()*2000);
                }
            }
            rd.renderScene(scene , camera, vp);
        }
    }
}
