/**
 * Copyright deepsoul ( http://wonderfl.net/user/deepsoul )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/77kM
 */

package
{
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import gs.TweenMax;
    import gs.easing.*;
    
    public class FunkyBalls extends MovieClip
    {
        private var ball : MovieClip;
        private var ballsArray : Array;
        private var clickedCounter : uint = 0;
        private var colorPool:Array = new Array(0xBF0A2C, 0x5E0014, 0x213CF2, 0xF4193F2, 0xF29F05, 0xF27405, 0x555555, 0x999999);
        
        public function FunkyBalls()
        {
            this.addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
        
        private function addedToStageHandler(e:Event):void
        {
            this.removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.addEventListener(Event.RESIZE, resizeHandler);
            init();
        }
        
        private function setActive(b:Boolean = true):void
        {
            this.mouseChildren = b;
        }
        
        private function resizeHandler(e:Event):void
        {
            setActive(false);
            TweenMax.killDelayedCallsTo(reposBalls);
            TweenMax.delayedCall(.2, reposBalls);
        }
        
        private function reposBalls():void
        {
            for (var i:uint; i < numChildren; i++)
            {
                if( Object(getChildAt(i)).mouseEnabled ) TweenMax.to(getChildAt(i), .55, {x:Math.random()*stage.stageWidth, y:Math.random()*stage.stageHeight, ease:Expo.easeInOut});
            }
            TweenMax.delayedCall(.7, setActive);
        }
        
        private function init():void
        {
            setActive(false);
            var maxAmmount : uint = Math.random()*100 + 50;
            ballsArray = new Array;
            for (var i:uint; i < maxAmmount; i++) TweenMax.delayedCall(i/20, randomBall, [i]);
            TweenMax.delayedCall(3 + 1/20, setActive);
        }
        
        private function randomBall(_id : uint):void
        {
            var c : Number = colorPool[Math.round(Math.random()*(colorPool.length-1))];
            var rNum : int = Math.random()*60 + 40;
            ball = new MovieClip ();
            ball.ID = _id;
            ball.graphics.beginFill(0x111111);
            ball.graphics.drawCircle(0 ,0 , rNum);
            ball.graphics.endFill();
            ball.graphics.beginFill(c);
            ball.graphics.drawCircle(0, 0, rNum-(rNum/10 + 2));
            ball.graphics.endFill();
            ball.x = Math.random()* stage.stageWidth;
            ball.y = Math.random()* stage.stageHeight;
            ballsArray.push(ball);
            ball.scaleX = ball.scaleY = 0;  
            addChild(ball); 
            TweenMax.to(ball, 2.5, {scaleX:1, scaleY:1, ease:Elastic.easeOut, onComplete: addListeners, onCompleteParams:[_id]});
        }
        
        private function addListeners(_id:uint):void
        {
            ballsArray[_id].mouseChildren=  false;
            ballsArray[_id].buttonMode = true;
            ballsArray[_id].addEventListener(MouseEvent.ROLL_OUT, mouseHandler);
            ballsArray[_id].addEventListener(MouseEvent.ROLL_OVER, mouseHandler);
            ballsArray[_id].addEventListener(MouseEvent.CLICK, mouseHandler);
        }
        
        private function mouseHandler(e:MouseEvent):void
        {
           switch(e.type)
           {
               case MouseEvent.ROLL_OVER:
                   TweenMax.to(e.target, .6, {tint:0x000000, ease:Expo.easeOut});
                   break;
                   
               case MouseEvent.ROLL_OUT:
                   if ( e.target.mouseEnabled )TweenMax.to(e.target, .45, {tint:null, ease:Expo.easeOut});
                   break;
               
               case MouseEvent.CLICK:
                   e.target.mouseEnabled = false;
                   e.target.removeEventListener(MouseEvent.ROLL_OUT, mouseHandler);
                   e.target.removeEventListener(MouseEvent.ROLL_OVER, mouseHandler);
                   e.target.removeEventListener(MouseEvent.CLICK, mouseHandler);
                   setActive(false);
                   TweenMax.to(e.target, .55, {onComplete:checkStatus, scaleX:0, scaleY:0, ease:Back.easeIn});
                   break;
           }
        }
       
        private function checkStatus():void
        {
            clickedCounter ++;
            reposBalls();
            if(clickedCounter == ballsArray.length)
            {
                clickedCounter = 0;
                while(numChildren) removeChildAt(0);
                init();
            }
        }

    }
}