/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/77PA
 */

package {
     import flash.display.*;
    import flash.events.*;
    import flash.net.*
    import flash.text.*;
    import flash.media.*;
    
    public class Main extends Sprite {
        private var txt1:TextField = new TextField();
        private var txt2:TextField = new TextField();
        private var txt3:TextField;
        
        private var ar:Array;
        private var logar:Array;
        private var gs:GroupSpecifier;//接続グループ機能制限
        private var nc:NetConnection;
        private var group:NetGroup;
        private var reqflg:Boolean;
        private var groupName:String;
        private var cnt1:int = 1;
        private var memberInfo:Object = new Object();
        //private var CMD_1:String = "create";
        
        private var camera:Camera;
        private var video:Video;
        private var video2:Video;
        private var mic:Microphone;
        
        private var btn1:Btn;
        private var btn2:Btn;
        
        
        //ストリーミングフラグ
        private var liveCam:Boolean = true;
        private var liveMic:Boolean = true;
        
        private var s:Sprite;

        public function Main() {
             
            btn1 = new Btn();
            btn1.init({label:"FULL SCREEN",type:1,width:100});
            btn1.x = 400; btn1.y = 445;
            btn1.addEventListener(MouseEvent.CLICK,screenMode);
            //addChild(btn1);
            btn2 = new Btn();
            btn2.init({label:"ON LINE",type:1,width:80});
            btn2.x = 200; btn2.y = 445;
            btn2.addEventListener(MouseEvent.CLICK,connectNode);
            //addChild(btn2);
               
            txt1.text = "aaa";
            
            // グループ機能制限
            groupName = new String();
            groupName = "net.wonderfl.ozmap.test4"
            gs = new GroupSpecifier(groupName);//接続グループ名
            gs.postingEnabled = true;//ポスティング許可
            gs.ipMulticastMemberUpdatesEnabled = true;//IP情報のマルチキャスト許可
            gs.multicastEnabled = true;//NetStreamによるストリーミング許可
            gs.objectReplicationEnabled = true;//オブジェクトの複製許可
            gs.routingEnabled = true;//NetGroupでの転送メソッド許可
            gs.serverChannelEnabled = true;//メンバーへサーバーチャンネルを開く権限を付与
            
            // RTMFPコネクション
            nc = new NetConnection();
            //イベント NET_STATUS
            nc.addEventListener(NetStatusEvent.NET_STATUS, procNetStatus);
            //接続
            nc.connect("rtmfp://p2p.rtmfp.net/3ea2ccfc17227d122a776d41-31e9e4d71a17/");
            logar = new Array();
            reqflg = false;

        }
        
        private function screenMode(e:MouseEvent):void{      
            if(stage.displayState == StageDisplayState.FULL_SCREEN){
                stage.displayState = StageDisplayState.NORMAL;//元に戻す
                btn1.text = "full screen";
                btn1.onLight = false;
            }
            else{
                stage.displayState = StageDisplayState.FULL_SCREEN;//フルスクリーンモード
                //btn1.text = "normal";
                btn1.onLight = true;
            }
            e.stopPropagation();//イベントの伝播を止める            
        }

        
//----------------------------------------------------------------------------    
        private const WIDTH:int = 160;
        private const HEIGHT:int = 120;
    
        private function startCamera():void{
            
            camera = Camera.getCamera();
            if ( camera == null ) {
            } else {
                start();
                

            }
            
        }
        

        private function aa(e:Event):void{
            if(e.target.scaleY < e.target.scaleX)e.target.scaleY+=0.05;
            else{
                e.target.scaleY = e.target.scaleX;
                
                e.target.removeEventListener(Event.ENTER_FRAME,aa);
            }
        }
        private function bb(e:Event):void{
            if(0.01<e.target.scaleY)e.target.scaleY/=2;
            else{
                stage.removeChild(Sprite(e.target));
                e.target.removeEventListener(Event.ENTER_FRAME,bb);
            }
        }


       private function onCapture(e:ActivityEvent):void{
                if(camera.muted == false){
                    btn2.onLight = true;
                    btn2.removeEventListener(MouseEvent.CLICK,connectNode);
                    camera.removeEventListener(ActivityEvent.ACTIVITY,onCapture);
                    
                    with(Sprite(stage.getChildByName(nc.nearID))){
                        graphics.clear();
                        graphics.beginFill(0x000000, 0.5);
                        graphics.drawRoundRect(-10,-10,video.width+20,video.height+20,5);
                        graphics.endFill();
                        addChild(video);
                        scaleY=0;
                        addEventListener(Event.ENTER_FRAME,aa);
                    }
                    /*btn2.addEventListener(MouseEvent.CLICK,function():void{
                        _sendStream.close();
                        btn2.onLight = false;
                        btn2.addEventListener(MouseEvent.CLICK,connectNode);
                    });*/
 
                }

            }
        
        private function start():void {
            camera.addEventListener(ActivityEvent.ACTIVITY,onCapture);
            //camera.setMode(WIDTH,HEIGHT, 30);//カメラ設定 width, height, frame
            video = new Video(camera.width,camera.height);
            //video = new Video(WIDTH,HEIGHT);//ビデオサイズ width, height
            
            this.video.attachCamera(camera);

        }
//------------------------------------------------------------------------------        
        private function initCanvas():void {
            //addChild(s);
            addChild(txt1);
            addChild(txt2);
            addChild(btn1);
            addChild(btn2);
            //txt1.text = group.estimatedMemberCount.toString();
            with(txt1){
                width = 400;
                y = 400;
                textColor = 0x0000ff;
            }
            with(txt2){            
                width = 400;
                height = 400;
                //type = "input";
                //border = true;
            }
            
            s = new Sprite();
                    with(s.graphics){                     
                         beginFill(0x000000,0.5);
                         drawRoundRect(0,0,50,50,5);
                         endFill();
                     }
                     with(s){
                         x =Math.random()*350;
                         y =Math.random()*200;
                         addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{
                            e.currentTarget.startDrag();
                         });
                         addEventListener(MouseEvent.MOUSE_UP,function(e:MouseEvent):void{
                            e.currentTarget.stopDrag();
                         });
                         name = nc.nearID;
                         scaleY = 0;
                         addEventListener(Event.ENTER_FRAME,aa);
                     }
            stage.addChild(s);
            
            //txt1.text = nc.nearID.toString();
            //txt1.appendText("\n"+nc.nearNonce.toString());
          
        }
//--------------------------------------------------------------------------        
        //送信用ストリームの宣言
        private var _sendStream:NetStream;
        // パブリッシュするストリームの名前
        private var _streamName:String = "directstream";
        
 
        // NetConnection.Connect.Success の時に呼ばれる 
        private function onConnect():void {
            // NetStream インスタンス生成
            _sendStream = new NetStream(nc, NetStream.DIRECT_CONNECTIONS);
            // イベントハンドラーの登録
            _sendStream.addEventListener(NetStatusEvent.NET_STATUS, procNetStatus);
            // カメラ設定
            if(liveCam == true && camera != null){
                _sendStream.attachCamera(camera);
            }
            //マイク設定
            
            mic = Microphone.getMicrophone();    
            //mic.setLoopBack(true);
            mic.codec = SoundCodec.SPEEX;
            mic.setUseEchoSuppression(true);
            _sendStream.attachAudio(mic);
            

            // パブリッシュ開始
            _sendStream.publish(_streamName);
            
        }
//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
        // 受信用ストリームの宣言
        private var _recvStream:NetStream;
        // パプリッシュしているノードの ID
        private var _publisherID:String = "xxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        // 受信するストリームの名前
 
        // NetConnection.Connect.Success の時に呼ばれる 
        private function onConnect2(cam:Boolean=true,mic:Boolean=true):void {
            // NetStream インスタンス生成
            _recvStream = new NetStream(nc, _publisherID);
            //_recvStream.receiveVideo(cam);//ビデオ受信の可否
            //_recvStream.receiveAudio(mic);//オーディオ受信の可否    
            // イベントハンドラーの登録
            _recvStream.addEventListener(NetStatusEvent.NET_STATUS, procNetStatus);
            // 受信開始 - 引数は送信側 publish() の引数に対応
            _recvStream.play(_streamName);
            
            //ビデオ初期化
            video = new Video( WIDTH, HEIGHT );//フレームサイズ 
            video.attachNetStream(_recvStream);
            
            with(Sprite(stage.getChildByName(memberInfo[_publisherID]))){
                        graphics.clear();
                        graphics.beginFill(0x000000, 0.5);
                        graphics.drawRoundRect(-10,-10,video.width+20,video.height+20,5);
                        graphics.endFill();
                        addChild(video);
                        scaleY=0;
                        addEventListener(Event.ENTER_FRAME,aa);
            }
            txt2.appendText(video.width.toString());

        }
        
        
//-----------------------------------------------------------------------------        
        
        
        
        
        
        private function connectNode(e:MouseEvent):void{
            
            startCamera();
            group.post({ID:nc.nearID});
            onConnect();
            //logar.push(nc.nearID);
            

        }

        //通信イベント
        private function procNetStatus(e:NetStatusEvent):void {
            
           
            var i:int;
            var j:int;
            var now:Date = new Date();
            txt2.appendText("[ "+now.toLocaleDateString()+" ] ");
            txt2.appendText(now.toLocaleTimeString()+"    ");
            txt2.appendText(e.info.code);
            
            switch (e.info.code) {
                case "NetConnection.Connect.Success"://接続確立
                    group = new NetGroup(nc, gs.groupspecWithAuthorizations());
                    group.addEventListener(NetStatusEvent.NET_STATUS, procNetStatus);
                    stage.addEventListener(Event.ENTER_FRAME,function():void{
                        
                        txt1.text = "objRepRece:"+Math.round(group.info.objectReplicationReceiveBytesPerSecond).toString()+" byte   ";
                        txt1.appendText("objSend:"+Math.round( group.info.objectReplicationSendBytesPerSecond ).toString()+" byte \n");
                        
                        txt1.appendText("postCtrl:"+Math.round( group.info.postingReceiveControlBytesPerSecond ).toString()+" byte   ");
                        txt1.appendText("postReceData:"+Math.round( group.info.postingReceiveDataBytesPerSecond ).toString()+" byte   ");
                        txt1.appendText("postSendCtrl:"+Math.round( group.info.postingSendControlBytesPerSecond ).toString()+" byte   ");
                        txt1.appendText("postSendData:"+Math.round( group.info.postingSendDataBytesPerSecond ).toString()+" byte \n");
                        
                        txt1.appendText("routRece:"+Math.round( group.info.routingReceiveBytesPerSecond ).toString()+" byte   ");
                        txt1.appendText("routSend:"+Math.round( group.info.routingSendBytesPerSecond ).toString()+" byte   ");
                        //txt1.appendText(group.info..toString()+" ");
                        
                        
                        
                    });

                    //txt2.appendText("\n"+nc.nearID);
                    break;
                case "NetGroup.Connect.Success"://グループ接続確立
                    initCanvas();//開始
              
                    break;
                case "NetGroup.Neighbor.Connect"://メンバー接続  
                    /*if (logar.length == 0) {
                        reqflg = true;
                        group.addWantObjects(0, 0);//同期
                     }*/
                     cnt1++;
                     txt2.appendText(" "+cnt1.toString());
                     //txt2.appendText(" "+Math.round(group.estimatedMemberCount).toString());
                     //txt2.appendText("\nPeerID:"+e.info.peerID);
                     //txt2.appendText("\nネイバー："+e.info.neighbor);
                     txt2.appendText("\n");
                     memberInfo[e.info.peerID] = e.info.neighbor;
                     txt2.appendText("obj:"+memberInfo[e.info.peerID]+"\n");
                     s = new Sprite();

                     with(s.graphics){                     
                         beginFill(0x000000,0.5);
                         drawRoundRect(0,0,50,50,5);
                         endFill();
                     }
                     with(s){
                         x =Math.random()*350;
                         y =Math.random()*200;
                         addEventListener(MouseEvent.MOUSE_DOWN,function(e:MouseEvent):void{
                            e.currentTarget.startDrag();
                         });
                         addEventListener(MouseEvent.MOUSE_UP,function(e:MouseEvent):void{
                            e.currentTarget.stopDrag();
                         });
                         name = memberInfo[e.info.peerID];
                         scaleY = 0;
                         addEventListener(Event.ENTER_FRAME,aa);
                     }
                     txt2.appendText("\n"+s.name);
                     stage.addChild(s);
                     txt2.appendText("\nName:"+stage.getChildByName(memberInfo[e.info.peerID]).name);
                     
                    _publisherID = e.info.peerID;
                    onConnect2();
                     
                    break;
                case "NetGroup.Neighbor.Disconnect"://メンバー切断
                    cnt1--;
                    txt2.appendText(" "+cnt1.toString());
                    //txt2.appendText(" "+Math.round(group.estimatedMemberCount).toString());
                    //txt2.appendText("\nPeerID:"+e.info.peerID);
                    //txt2.appendText("\nネイバー："+e.info.neighbor);
                    txt2.appendText("\n");
                    //stage.removeChild( stage.getChildByName(e.info.peerID));
                    //delete stage.getChildByName(memberInfo[e.info.peerID]);
                    //stage.removeChild(stage.getChildByName(memberInfo[e.info.peerID]));
                    stage.getChildByName(memberInfo[e.info.peerID]).addEventListener(Event.ENTER_FRAME,bb);
                    delete memberInfo[e.info.peerID];
                    break;
//ポスト受信------------------------
                case "NetGroup.Posting.Notify"://メンバーからのポスト受信
                    //txt2.appendText(" "+e.info.message.cmd);
                    var obj:Object = e.info.message;//メッセージオブジェクト
                    
                    group.addHaveObjects(0, 0);//同期
                    //コマンド-----------------------------------------
                    
                    _publisherID = obj.ID;
                    onConnect2();
                    txt2.appendText("\nID: "+_publisherID);
                    //logar.push(obj);//メッセージをログに追記
                    


                    break;
                case "NetGroup.Replication.Request"://隣接ノードからの同期要求
                    txt2.appendText("\nrequestID:"+e.info.requestID+"\n");
                    if (e.info.index == 0) {
                        group.writeRequestedObject(e.info.requestID, {log: logar});
                    }
                    break;
                case "NetGroup.Replication.Fetch.Result"://同期要求を満たした
                    if (e.info.index == 0) {
                        reqflg = false;
                        logar = e.info.object.log;
                        group.addHaveObjects(0, 0);
                        /*for (i = 0; i < logar.length; ++i) {
                            _publisherID = logar[i].ID;
                            onConnect2({cam:logar[i].cam,mic:logar[i].mic});
                        }*/
                        

                    }
                    break;
                case "NetStream.Connect.Closed"://ストリーム切断
                    //video.clear();
                    //stage.removeChild(video);
                    break;
            }
            txt2.appendText("\n");
            txt2.scrollV = txt2.maxScrollV;
        }
    }
}



//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////


import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var sw:Boolean;//ライトON/OFF
    
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x0099FF;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        
        draw();
    }
    
    public function set text(str:String):void{
        txt.text = str;
    }
    public function get onLight():Boolean{
        return sw;
    }
    public function set onLight(flag:Boolean):void{
        sw = flag;
        light.visible = sw;
    }



    
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
        light.visible = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        //light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        //light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        //light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        //light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}




