/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/76jL
 */

// Matrix conversion test (PaperVision 2.0 and native flash matrices)
//
// pv2nativeMatrix( pv:org.papervision3d.core.math.Matrix3D ):flash.geom.Matrix3D
// native2pvMatrix( native:flash.geom.Matrix3D ):org.papervision3d.core.math.Matrix3D

package {
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.utils.getTimer;
    import flash.display.Sprite;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.materials.*;
    import org.papervision3d.core.math.Matrix3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;

    [SWF( backgroundColor='0x000000', frameRate='30', scaleMode='noScale' )]

    public class Main extends BasicView {
        public var pvClone:Plane;    // red
        public var nativeSrc:Sprite; // white

        public var pvSrc:Plane;        // green
        public var nativeClone:Sprite; // blue

        public var srcSquare:Sprite;
        public var cloneSquare:Sprite;

        public var container:Sprite;

        public var text:String = " \
        flash.geom.Matrix3D <-> org.papervision3d.core.math.Matrix3D conversion demo \
        color codes - \
        \
        PV source plane: green \
        Sprite with cloned matrix: blue \
        \
        Source Sprite: white \
        PV plane with cloned matrix: red \
        \
        Click to shift Sprites to the right";
        
        public var tf:TextField;

        public function Main() {
            super();
            tf = new TextField;
            tf.text = text;
            tf.width = 600;
            tf.height = 400;
            tf.textColor = 0xFFFFFF;
            stage.addChildAt( tf, 0 );

            camera.z = -100;
            camera.focus = 10;
            camera.zoom = 10;

            var proj:PerspectiveProjection = new PerspectiveProjection();
            proj.projectionCenter = new Point(0,0);
            proj.focalLength = 100;

            var cloneMat:ColorMaterial = new ColorMaterial( 0xFF0000, 0.5 );
            cloneMat.doubleSided = true;
            pvClone = new Plane( cloneMat, 100, 100 );
            scene.addChild( pvClone );

            var srcMat:ColorMaterial = new ColorMaterial( 0x00FF00, 0.5 );
            srcMat.doubleSided = true;
            pvSrc = new Plane( srcMat, 100, 100 );
            scene.addChild( pvSrc );

            srcSquare = new Sprite;
            srcSquare.graphics.beginFill(0xFFFFFF);
            srcSquare.graphics.drawRect(0, 0, 100, 100)
            srcSquare.alpha = 0.5;
            srcSquare.x = srcSquare.y = -50;

            cloneSquare = new Sprite;
            cloneSquare.graphics.beginFill(0x0000FF);
            cloneSquare.graphics.drawRect(0, 0, 100, 100)
            cloneSquare.alpha = 0.5;
            cloneSquare.x = cloneSquare.y = -50;

            nativeSrc = new Sprite;
            nativeSrc.addChild( srcSquare );
            nativeSrc.transform.perspectiveProjection = proj;

            nativeClone = new Sprite;
            nativeClone.addChild( cloneSquare );
            nativeClone.transform.perspectiveProjection = proj;

            container = new Sprite;
            container.addChild( nativeSrc );
            container.addChild( nativeClone );
            addChild( container );

            addEventListener( Event.ENTER_FRAME, enterFrame );
            stage.addEventListener( MouseEvent.CLICK, click );
        }

        public var shift:Number = 0;
        protected function click( e:Event ):void {
            if( shift === 0 ) {
                shift = 10;
            } else {
                shift = 0;
            }
        }

        protected function enterFrame( e:Event ):void {
            container.x = stage.stageWidth/2 + shift;
            container.y = stage.stageHeight/2;

            nativeSrc.scaleX = 1-Math.sin( getTimer()/3000 ) / 6;
            nativeSrc.x = 100 + Math.sin( getTimer()/1000 ) * 20;
            nativeSrc.y = Math.sin( getTimer()/1000 + Math.PI/3 ) * 20;
            nativeSrc.z = 50 + Math.sin( getTimer()/1000 + Math.PI*2/3 ) * 20;
            nativeSrc.rotationX++;
            nativeSrc.rotationY++;
            nativeSrc.rotationZ++;
            pvClone.copyTransform( native2pvMatrix( nativeSrc.transform.matrix3D ) );

            pvSrc.scaleX = scaleX = 1+Math.sin( getTimer()/3000 ) / 6;
            pvSrc.x = -100 - Math.sin( getTimer()/1000 ) * 20;
            pvSrc.y = -Math.sin( getTimer()/1000 + Math.PI/3 ) * 20;
            pvSrc.z = 50-Math.sin( getTimer()/1000 + Math.PI*2/3 ) * 20;
            pvSrc.rotationX--;
            pvSrc.rotationY--;
            pvSrc.rotationZ--;
            pvSrc.updateTransform();
            nativeClone.transform.matrix3D = pv2nativeMatrix( pvSrc.transform );

            renderer.renderScene( scene, camera, viewport );
        }

        public function pv2nativeMatrix( pv:org.papervision3d.core.math.Matrix3D ):flash.geom.Matrix3D {
            var native:flash.geom.Matrix3D = new flash.geom.Matrix3D;
            var raw:Vector.<Number> = new Vector.<Number>(16);

            raw[00] = pv.n11;
            raw[01] = pv.n21;
            raw[02] = pv.n31;
            raw[03] = pv.n41;
            raw[04] = pv.n12;
            raw[05] = pv.n22;
            raw[06] = pv.n32;
            raw[07] = pv.n42;
            raw[08] = pv.n13;
            raw[09] = pv.n23;
            raw[10] = pv.n33;
            raw[11] = pv.n43;
            raw[12] = pv.n14;
            raw[13] = pv.n24;
            raw[14] = pv.n34;
            raw[15] = pv.n44;

            native.rawData = raw;
            native.append( new flash.geom.Matrix3D( Vector.<Number>( [
                            1, 0, 0, 0,
                            0, -1, 0, 0,
                            0, 0, 1, 0,
                            0, 0, 0, 1 
                        ] ) ) );

            return native;
        }

        public function native2pvMatrix( native:flash.geom.Matrix3D ):org.papervision3d.core.math.Matrix3D {
            var pv:org.papervision3d.core.math.Matrix3D = new org.papervision3d.core.math.Matrix3D;
            var flipped:flash.geom.Matrix3D = native.clone();

            flipped.append( new flash.geom.Matrix3D( Vector.<Number>( [
                            1, 0, 0, 0,
                            0, -1, 0, 0,
                            0, 0, 1, 0,
                            0, 0, 0, 1 
                        ] ) ) );


            pv.n11 = flipped.rawData[00];
            pv.n21 = flipped.rawData[01];
            pv.n31 = flipped.rawData[02];
            pv.n41 = flipped.rawData[03];
            pv.n12 = flipped.rawData[04];
            pv.n22 = flipped.rawData[05];
            pv.n32 = flipped.rawData[06];
            pv.n42 = flipped.rawData[07];
            pv.n13 = flipped.rawData[08];
            pv.n23 = flipped.rawData[09];
            pv.n33 = flipped.rawData[10];
            pv.n43 = flipped.rawData[11];
            pv.n14 = flipped.rawData[12];
            pv.n24 = flipped.rawData[13];
            pv.n34 = flipped.rawData[14];
            pv.n44 = flipped.rawData[15];

            return pv;
        }
    }
}

