/**
 * Copyright debosotnas ( http://wonderfl.net/user/debosotnas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/76hU
 */

package {
	import flash.display.MovieClip;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	/**
	 * ...
	 * @author obed.santos@gmail.com
	 */
	public class Main extends MovieClip {
		
		private const ANCHO_ST:uint = stage.stageWidth;
		private const ALTO_ST:uint = stage.stageHeight;
		private const RADIO_MAXIMO:uint = 100;
		private const RADIO_MINIMO:uint = 10;
		private const CANTIDAD_CIRCULOS:uint = 11;
		private const CANT_ALPHA:Number = .5;
		
		private var arr_circulos:Array;
		
		public var txt_msg:TextField;
		public var mc_r:MovieClip;
		public var mc_fondo:MovieClip;
		
		public function Main() {
			stage.frameRate = 60;
			
			mc_r = new MovieClip();
			addChild(mc_r);
			mc_r.x = ANCHO_ST / 2 ;
			mc_r.y = ALTO_ST / 2;
			
			mc_fondo = new MovieClip();
			mc_fondo.graphics.beginFill(0xFFFFFF);
			mc_fondo.graphics.drawRect(0, 0, ANCHO_ST, ALTO_ST);
			mc_fondo.graphics.endFill();
			addChild(mc_fondo);
			
			stage.addEventListener(MouseEvent.MOUSE_MOVE, on_mouse_move);
			stage.addEventListener(MouseEvent.CLICK, on_mouse_click);
			generar_circulos(CANTIDAD_CIRCULOS);
			
			txt_msg = new TextField();
			txt_msg.text = "Click to change color!";
			txt_msg.autoSize = "left";
			txt_msg.x = ANCHO_ST / 2 - txt_msg.width / 2;
			txt_msg.y = ALTO_ST - txt_msg.textHeight * 1.5;
			addChild(txt_msg);
		}
		
		private function on_mouse_click(e:MouseEvent):void {
			var color_nuevo:uint = Math.random() * 0xFFFFFF;
			for (var i:int = 0; i < CANTIDAD_CIRCULOS; i++) {
				var temp_cir:Circulo = Circulo(arr_circulos[i]);
				temp_cir.cambiar_color(i, color_nuevo);
			}
		}
		
		private function generar_circulos(cant:uint):void {
			arr_circulos = new Array(cant);
			var salto_radio:Number = (RADIO_MAXIMO - RADIO_MINIMO) / cant;
			var resta_radio:Number = 0;
			for (var i:int = 0; i < cant; i++) {
				var cir:Circulo = new Circulo(RADIO_MAXIMO - resta_radio, i, CANT_ALPHA);

				addChild(cir);
				cir.x = ANCHO_ST / 2 ;
				cir.y = ALTO_ST / 2;
				
				arr_circulos[i] = cir;
							
				resta_radio += salto_radio;
			}
		}
		
		private function on_mouse_move(e:MouseEvent):void {
			var pos_x:Number = Math.abs(mouseX - (ANCHO_ST / 2));
			var pos_y:Number = Math.abs(mouseY - (ALTO_ST / 2));
			var distancia_a_centro:Number = Math.sqrt( pos_x * pos_x + pos_y * pos_y);
			
			var salto_dist:Number = distancia_a_centro / CANTIDAD_CIRCULOS;
			var suma_dist:Number = 0;
			for (var i:int = 0; i < CANTIDAD_CIRCULOS; i++) {
			   var temp_cir:Circulo = Circulo(arr_circulos[i]);
				
			   temp_cir.x = ANCHO_ST / 2 + Math.sin(Math.atan2(mc_r.mouseX, mc_r.mouseY)) * suma_dist;
				temp_cir.y = ALTO_ST / 2 + Math.cos(Math.atan2(mc_r.mouseX, mc_r.mouseY)) * suma_dist;
				
				suma_dist += salto_dist;
			}
		}
		
	}
	
}

import flash.display.MovieClip;

class Circulo extends MovieClip {
	private var color_c:uint = 0x000000;
	private var radio_c:Number;
	
	public function Circulo(rad:Number, col:uint, alfa:Number = 1):void {
		alpha = alfa;
		radio_c = rad;
		color_c = (col + 1) % 2 == 0 ? 0xFFFFFF : color_c;
		
		graphics.clear();
		graphics.beginFill(color_c);
		graphics.drawCircle(0, 0, radio_c);
		graphics.endFill();
	}
	public function cambiar_color(pos:uint, nuevo_col:uint):void {
		color_c = (pos + 1) % 2 == 0 ? 0xFFFFFF : nuevo_col;
		graphics.clear();
		graphics.beginFill(color_c);
		graphics.drawCircle(0, 0, radio_c);
		graphics.endFill();		
	}
	
}