/**
 * Copyright mchang ( http://wonderfl.net/user/mchang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/76ad
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.net.URLRequest;
	import flash.geom.Matrix;
	import flash.system.LoaderContext;
	
	[SWF(width = 465, height = 465, frameRate = 60, background = 0x000000)]
	
	public class Sample2 extends Sprite
	{
		
		private var _shape:Shape = new Shape();
		private var _loader:Loader = new Loader();
		private var _bg:BitmapData;
		private var _ct:ColorTransform;
		
		private var _particles:Array = new Array();
		
		public function Sample2()
		{
			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
			_loader.load(new URLRequest('http://wonderfl.minaco.net/icon.png'), new LoaderContext(true));
	
			_ct = new ColorTransform(1, 1, 1, 1, -25, -25, -25);
			_bg = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
			
			addChild(new Bitmap(_bg));   		
		}
		
		private function completeHandler(e:Event):void
		{
			var c:LoaderInfo = _loader.contentLoaderInfo;
			var tile:BitmapData = new BitmapData(c.width, c.height, false, 0x000000);
			tile.draw(c.content);

			for (var x:uint = 0; x < c.width; x++)
			{
				for (var y:uint = 0; y < c.height; y++)
				{
					var particle:Particle = new Particle();
					particle.x = stage.stageWidth /2 + x - (c.width / 2);
					particle.y = stage.stageHeight / 2 + y - (c.height / 2);
					particle.color = tile.getPixel(x, y);
					particle.speedX = 0;
					particle.speedY = 0;
					_particles.push(particle);
				}
			}
			
			stage.addEventListener(MouseEvent.CLICK, clickHandler);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		private function clickHandler(e:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.CLICK, clickHandler);

			for (var i:uint = 0; i < _particles.length; i++)
			{
				_particles[i].speedX = (Math.random() - 0.5) * 2;
				_particles[i].speedY = (Math.random() - 0.5) * 2;
			}
		}
		
		private function enterFrameHandler(e:Event):void
		{
			_bg.colorTransform(_bg.rect, _ct);
			
			// 更新
			for (var i:uint = 0; i < _particles.length; i++)
			{
				_particles[i].x += _particles[i].speedX;
				_particles[i].y += _particles[i].speedY;
			}
						
			// 描画
			for (var j:uint = 0; j < _particles.length; j++)
			{
				_bg.setPixel(_particles[j].x, _particles[j].y, _particles[j].color);
			}
		}
	}
}


class Particle 
{
	public var x:Number;
	public var y:Number;
	public var color:uint;
	public var speedX:Number;
	public var speedY:Number;
	
	public function Particle():void
	{
	}
}

