/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/76I0
 */

package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.events.TimerEvent;
  import flash.text.TextField;
  import flash.text.TextFieldAutoSize;
  import flash.utils.Timer;

  import funnel.*;

  [SWF(backgroundColor="0x808080")]

  public class CalibrationByAverage extends Sprite {
    // Arduino
    private var arduino:Arduino;

    // 入力波形を表示するためのシグナルスコープ
    private var signalScope:SignalScope;

    // 光センサを接続したピン
    private var sensorPin:Pin;

    // 一定時間のキャリブレーションを行うためのタイマ
    private var calibrationTimer:Timer;

    // 状態やキャリブレーション結果を表示するためのテキストフィールド
    private var textField:TextField;

    public function CalibrationByAverage() {
      // Arduinoのインスタンスを生成し、sensorPinにアナログ入力0をセット
      arduino = new Arduino(Arduino.FIRMATA);
      sensorPin = arduino.analogPin(0);

      // シグナルスコープを生成してセット
      signalScope = new SignalScope(10, 10, 200, 
                                    "Brightness");
      this.addChild(signalScope);

      // テキストフィールドを生成してセット
      textField = new TextField();
      textField.x = 15;
      textField.y = 140;
      this.addChild(textField);

      // キャリブレーション区間を決めるためのタイマを生成
      // 5000ms後にonTimerCompleteが呼ばれるようにセット
      calibrationTimer = new Timer(5000, 1);
      calibrationTimer.addEventListener(
        TimerEvent.TIMER_COMPLETE, onTimerComplete);

      // テキストフィールドにキャリブレーション中であることを表示してタイマをスタート
      textField.text = "Calibrating...";
      textField.autoSize = TextFieldAutoSize.LEFT;
      calibrationTimer.start();

      // ENTER_FRAMEイベントに対するイベントリスナをセット
      this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    // タイマが完了したら以下を実行
    private function onTimerComplete(e:TimerEvent):void {
      // タイマを停止してイベントリスナを削除
      calibrationTimer.stop();
      calibrationTimer.removeEventListener(
        TimerEvent.TIMER_COMPLETE, onTimerComplete);

      // センサの平均値から閾値とヒステリシスを求める
      var threshold:Number = sensorPin.average * 0.9;
      var hysteresis:Number = 0;
      if (threshold > 0.5) {
        hysteresis = (1 - threshold) / 10;
      } else {
        hysteresis = (threshold) / 10;
      }

      // テキストフィールドの表示を更新
      textField.text = "Threshold = " + threshold.toFixed(3);
      textField.appendText(", Hysteresis = " 
                           + hysteresis.toFixed(3));

      // センサに求めた値を引数としたSetPointフィルタをセット
      sensorPin.addFilter(new SetPoint(
                          [threshold, hysteresis]));
    }

    // 毎フレームごとに以下を実行
    private function onEnterFrame(e:Event):void {
      // シグナルスコープの表示を更新
      signalScope.update(sensorPin);
    }
  }
}
