/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/75gw
 */

package 
{
	import flash.display.BlendMode;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.effects.utils.BitmapDrawCommand;
	import org.papervision3d.core.geom.Pixels
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.materials.BitmapColorMaterial;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	
	
	[SWF(width=465,height=465,backgroundColor=0x000000)]
	public class Main extends BasicView
	{
		private var NUM:int = 3000;
		private var rot:Number = 0;
		
		public function Main():void 
		{
			
			camera.zoom = 2 ;
			
			draw();
			startRendering();
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(event:Event):void 
		{
			rot += 1;
			
			camera.x = 500 * Math.sin(rot * Math.PI / 180);
			camera.z = 500 * Math.cos(rot * Math.PI / 180);
			camera.y = 500 * Math.cos(rot * Math.PI / 180);
			camera.zoom +=((mouseX+mouseY)/10-camera.zoom)/10;
		}
		
		private function draw():void 
		{
			var _effect:BitmapEffectLayer = new BitmapEffectLayer(viewport, 465, 465);
			_effect.addEffect(new BitmapLayerEffect(new BlurFilter(2, 2, 1)));
			
			_effect.drawCommand = new BitmapDrawCommand(null, null, BlendMode.SCREEN);
			viewport.containerSprite.addLayer(_effect);
			
			var pxs:Pixels = new Pixels(_effect);
			scene.addChild(pxs);
			
			for (var i:int = 0; i < NUM; i++)
			{
				var xx:Number = Math.random() * 1000 - 500;
				var yy:Number = Math.random() * 1000 - 500;
				var zz:Number = Math.random() * 1000 - 500;
				
				
				var px:Pixel3D = new Pixel3D(0xFFFFFFFF, xx, yy, zz);
				
				pxs.addPixel3D(px);
				
			}
		}
		
	}
	
}