/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/75Ky
 */

package {
	import flash.display.*;
	import flash.geom.*;
	import flash.events.Event;

	[SWF(width="300", height="400", backgroundColor="0x00404080", frameRate="20")]

	public class BoundBoxBlur extends Sprite {

		private var box:Sprite;
		private var spd_x:Number = 5;
		private var spd_y:Number = 7;
		private var rot:Number = 8;
		private var bmpdata:BitmapData;

		function BoundBoxBlur() {

			// ■ボックス
			box = MakeBox(60, 40, 1, 0xFFFFFFFF, 0x8040FF40);
			box.x = 50;
			box.y = 50;

			addChild(box);


			// ■合成用bitmap
			bmpdata = new BitmapData(
							stage.stageWidth,
							stage.stageHeight/2,
							true, 0xFF000000)

			var bmp:Bitmap = new Bitmap(bmpdata);
			bmp.y = stage.stageHeight/2;

			addChild(bmp);

			addEventListener(Event.ENTER_FRAME, onEnterFrame);

		}

		private function onEnterFrame(evt:Event): void {
			// box move
			box.x += spd_x;
			box.y += spd_y;
			box.rotation += rot;
			var boundbox:Rectangle = box.getBounds(stage);
			if ((spd_x < 0 && boundbox.left <= 0) ||
				(spd_x > 0 && boundbox.right >= stage.stageWidth)) {
				spd_x *= -1;
			}

			if ((spd_y < 0 && boundbox.top <= 0) ||
				(spd_y > 0 && boundbox.bottom >= stage.stageHeight/2)) {
				spd_y *= -1;
			}

			// update bitmap
			var ct:ColorTransform = new ColorTransform();
			var rect:Rectangle = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight/2);
			var matrix:Matrix = new Matrix();
			var temp_bmpdata:BitmapData = bmpdata.clone();
			bmpdata.fillRect(new Rectangle(0,0, bmpdata.width, bmpdata.height), 0xFF000000);
			ct.redMultiplier = 0.99;
			ct.greenMultiplier = 0.90;
			ct.blueMultiplier = 0.94;
			bmpdata.draw(temp_bmpdata, matrix, ct, BlendMode.NORMAL, rect, false);
			bmpdata.draw(stage, matrix, new ColorTransform(), BlendMode.NORMAL, rect, false);
		}
	}
}

import flash.display.Sprite;

function MakeBox(w:int, h:int, bold:int, lcolor:uint, fcolor:uint): Sprite {

	var spr:Sprite = new Sprite();

	spr.graphics.lineStyle(bold, lcolor & 0xFFFFFF, ((Number)(lcolor >> 24) & 0xFF) / 0xFF);
	spr.graphics.beginFill(fcolor & 0xFFFFFF, ((Number)(fcolor >> 24) & 0xFF) / 0xFF);
	spr.graphics.drawRect(-w/2, -h/2, w, h);
	spr.graphics.endFill();

	return spr;
}
