/**
 * Copyright maxs.maxs.90 ( http://wonderfl.net/user/maxs.maxs.90 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/75E5
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.filters.BlurFilter;
    import flash.events.MouseEvent;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFormatAlign;
    import flash.display.GradientType;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        var txtformat:TextFormat;
        var blur:BlurFilter;
        var dem:int = 5;
        var col:uint = 0xff6600;
        var container:Sprite = new Sprite();
        var FMenu:Sprite = new Sprite();
        var Ind:Boolean;
        public function FlashTest() {
            // write as3 code here..
            txtformat = new TextFormat();
            txtformat.bold = true;
            txtformat.font = "Arial";
            txtformat.size = 12;
            txtformat.color = 0xffffff;
            txtformat.align = TextFormatAlign.CENTER;
            //
            blur = new BlurFilter();
            blur.blurX = 5;
            blur.blurY = 5;
            //
            addChild(FMenu);
            addChild(container);
            colMenu();
            demMenu()
            Menu();
            BoxMenu();
            Box(50,100,50);
            Ind = true;
            addEventListener(Event.ENTER_FRAME,fr); 
        }
        function fr(event:Event){
            container.rotationX = (360 / stage.stageHeight) * mouseY;
            container.rotationY = (360 / stage.stageWidth) * mouseX;
        }

        function Plane(w:Number,h:Number,x_:Number,y_:Number,z_:Number,rx:Number,ry:Number,rz:Number){
            var pl:Sprite = new Sprite();
            pl.graphics.lineStyle(dem,col);
            pl.graphics.drawTriangles(Vector.<Number>([-(w/2),-(h/2), (w/2),-(h/2), -(w/2),(h/2), (w/2),(h/2)]),Vector.<int>([0,1,2, 1,2,3]),null);
            pl.x = x_;
            pl.y = y_;
            pl.z = z_;
            pl.rotationX = rx;
            pl.rotationY = ry;
            pl.rotationZ = rz;
            container.addChild(pl);
        }
        function Box(w:Number,h:Number,l:Number){
            container = new Sprite();
            addChild(container);
            Plane(w,h,     0,     0,-(l/2),  0,180,0);
            Plane(w,h,     0,     0, (l/2),  0,  0,0);
            Plane(l,h,-(w/2),     0,     0,  0,-90,0);
            Plane(l,h, (w/2),     0,     0,  0, 90,0);
            Plane(w,l,     0,-(h/2),     0,-90,  0,0);
            Plane(w,l,     0, (h/2),     0, 90,  0,0);
            container.x = stage.stageWidth/2;
            container.y = stage.stageHeight/2;
        }
        function Circle(n:Number,r:Number,h:Number){
            container = new Sprite();
            addChild(container);
            for(var i:int = 0; i < n; i ++){
                Plane(((2*Math.PI*r)/n),h,Math.cos(((360/n)*i)*(Math.PI/180))*r,Math.sin(((360/n)*i)*(Math.PI/180))*r,0,90,0,((360/n)*i)+90);
            }
            container.x = stage.stageWidth/2;
            container.y = stage.stageHeight/2;
        }
        function Inp(txt:String = "NaN",x_:Number = 0,y_:Number = 0){
            var txtF:TextField = new TextField(); 
            txtF.defaultTextFormat = txtformat;
            txtF.width = 80;
            txtF.height = 20;
            txtF.type = TextFieldType.INPUT;
            txtF.text = txt;
            txtF.maxChars = 3;
            txtF.restrict = "0-9";
            txtF.border = true;
            txtF.borderColor = 0xff6600;
            txtF.background = true;
            txtF.backgroundColor = 0x333333;
            txtF.x = x_;
            txtF.y = y_;
            return txtF;
        }
        function But(txt:String = "NaN",x_:Number = 0,y_:Number = 0,w:Number = 80,h:Number = 20){
            var cont:Sprite = new Sprite();
            cont.buttonMode = true;
            //
            cont.addEventListener(MouseEvent.MOUSE_OVER,m_over);
            cont.addEventListener(MouseEvent.MOUSE_OUT,m_out);
            function m_over(e:MouseEvent){
                cont.filters = [blur];
            }
            function m_out(e:MouseEvent){
                cont.filters = [];
            }
            //
            var txtF:TextField = new TextField(); 
            txtF.defaultTextFormat = txtformat;
            txtF.width = w;
            txtF.height = h;
            txtF.text = txt;
            txtF.border = true;
            txtF.borderColor = 0x333333;
            txtF.background = true;
            txtF.backgroundColor = 0xff6600;
            txtF.x = x_;
            txtF.y = y_;
            cont.addChild(txtF);
            return cont;
        }
        function BoxMenu(){
            FMenu = new Sprite();
            addChild(FMenu);
            var w:TextField = Inp("Width",(stage.stageWidth - 240),(stage.stageHeight - 40));
            FMenu.addChild(w);
            var h:TextField = Inp("Height",(stage.stageWidth - 160),(stage.stageHeight - 40));
            FMenu.addChild(h);
            var l:TextField = Inp("Length",(stage.stageWidth - 80),(stage.stageHeight - 40));
            FMenu.addChild(l);
            var btGo:Sprite = But("Go...",(stage.stageWidth - 240),(stage.stageHeight - 20),240,20);
            FMenu.addChild(btGo);
            //
            btGo.addEventListener(MouseEvent.CLICK,btGo_cl);
            function btGo_cl(event:MouseEvent){
                if(w.text !== "Width" && Number(w.text) > 0 && h.text !== "Height" && Number(h.text) > 0 && l.text !== "Length" && Number(l.text) > 0){
                    removeChild(container);
                    container = null;
                    Box(Number(w.text),Number(h.text),Number(l.text));  
                }
            }
        }
        function CircleMenu(){
            FMenu = new Sprite();
            addChild(FMenu);
            var w:TextField = Inp("Polygon num",(stage.stageWidth - 240),(stage.stageHeight - 40));
            FMenu.addChild(w);
            var h:TextField = Inp("Radius",(stage.stageWidth - 160),(stage.stageHeight - 40));
            FMenu.addChild(h);
            var l:TextField = Inp("Height",(stage.stageWidth - 80),(stage.stageHeight - 40));
            FMenu.addChild(l);
            var btGo:Sprite = But("Go...",(stage.stageWidth - 240),(stage.stageHeight - 20),240,20);
            FMenu.addChild(btGo);
            //
            btGo.addEventListener(MouseEvent.CLICK,btGo_cl);
            function btGo_cl(event:MouseEvent){
                if(w.text !== "Polygon num" && Number(w.text) > 0 && h.text !== "Radius" && Number(h.text) > 0 && l.text !== "Height" && Number(l.text) > 0){
                    removeChild(container);
                    container = null;
                    Circle(Number(w.text),Number(h.text),Number(l.text));  
                }
            }
        }
        function Menu(){
            var btBox:Sprite = But("Box",0,(stage.stageWidth - 40),80,20);
            addChild(btBox);
             var btCircle:Sprite = But("Circle",0,(stage.stageWidth - 20),80,20);
            addChild(btCircle);
            //
            btBox.addEventListener(MouseEvent.CLICK,btBox_cl);
            btCircle.addEventListener(MouseEvent.CLICK,btCircle_cl);
            //
            function btBox_cl(event:MouseEvent){
                removeChild(FMenu);
                FMenu = null;
                removeChild(container);
                container = null;
                BoxMenu();
                Box(50,100,50);
                Ind = true;
            }
            function btCircle_cl(event:MouseEvent){ 
                removeChild(FMenu);
                FMenu = null;
                removeChild(container);
                container = null;
                CircleMenu();
                Circle(15,50,50);
                Ind = false;
            }
        }
        function colMenu(){
            var color:Array = [0xff0000,0xffff00,0x00ff00,0x00ffff,0x0000ff,0xff00ff,0xff0000];
            var alp:Array = [1,1,1,1,1,1,1];
            var rt:Array = [0,42,84,126,168,210,255];
            var mat:Matrix = new Matrix();
            mat.createGradientBox(stage.stageWidth,20);
            var cont:Sprite = new Sprite();
            cont.graphics.lineStyle(2,0x666666);
            cont.graphics.beginGradientFill(GradientType.LINEAR,color,alp,rt,mat);
            cont.graphics.drawRect(2,2,(stage.stageWidth - 4),20);
            cont.graphics.endFill();
            addChild(cont);
            var colorBMD:BitmapData = new BitmapData(cont.width,cont.height);
            colorBMD.draw(cont);
            cont.addEventListener(MouseEvent.CLICK,rgb_cl);
            function rgb_cl(event:MouseEvent){
                col = colorBMD.getPixel(mouseX,mouseY);
                removeChild(container);
                container = null;
                if(Ind){
                    Box(50,100,50);
                }else{
                    Circle(15,50,50);
                }
            }
        }
        function demMenu(){
            var d:TextField = Inp("Line diameter",0,25);
            addChild(d);
            var btnGo_d:Sprite = But("Go...",0,45);
            addChild(btnGo_d);
            btnGo_d.addEventListener(MouseEvent.CLICK,btnGo_d_cl);
            function btnGo_d_cl(event:MouseEvent){
                if(d.text !== "Line diameter" && Number(d.text) > 0){
                   dem = int(d.text); 
                   removeChild(container);
                   container = null;
                   if(Ind){
                       Box(50,100,50);
                   }else{
                       Circle(15,50,50);
                   }                     
                }
            }
        }

    }
}