/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/74yc
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.ui.Keyboard;
    public class FlashTest extends Sprite {
		
		private var _container:/*LineData*/Array;
		private var _current:Point;
		private var _start:Point;
		private var _dir:Point;
		
		private const DIR_U:Point = new Point(0, -1);
		private const DIR_D:Point = new Point(0, 1);
		private const DIR_L:Point = new Point(-1, 0);
		private const DIR_R:Point = new Point(1, 0);

        public function FlashTest() {
			reset();
			
			this.addEventListener(Event.ENTER_FRAME, proc);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onDown);
        }
		
		private function reset():void {
            _container = new Array();
			_current = new Point(232, 232);
			_start = new Point(_current.x, _current.y);
			_dir = DIR_U;
		}
		
		private function onDown(e:KeyboardEvent):void {
			
			var isChanged:Boolean = false;
			
			if (e.keyCode == Keyboard.UP && !_dir.equals(DIR_D) && !_dir.equals(DIR_U)) {
				_dir = DIR_U;
				isChanged = true;
			}
			if (e.keyCode == Keyboard.DOWN && !_dir.equals(DIR_D) && !_dir.equals(DIR_U)) {
				_dir = DIR_D;
				isChanged = true;
			}
			if (e.keyCode == Keyboard.LEFT && !_dir.equals(DIR_L) && !_dir.equals(DIR_R)) {
				_dir = DIR_L;
				isChanged = true;
			}
			if (e.keyCode == Keyboard.RIGHT && !_dir.equals(DIR_L) && !_dir.equals(DIR_R)) {
				_dir = DIR_R;
				isChanged = true;
			}
			
			if (isChanged) {
				_container.push(new LineData(new Point(_start.x, _start.y), new Point(_current.x, _current.y)));
				_start.x = _current.x;
				_start.y = _current.y;
			}
		}
		
		private function proc(e:Event):void {
			var speed:Number = 2.0;
			_current = _current.add(new Point(_dir.x * speed, _dir.y * speed));
			
			if (_current.x < 0 || _current.x > 465 || _current.y < 0 || _current.y > 465) {
				reset();
			}
			
			this.graphics.clear();
			this.graphics.lineStyle(3, 0x000000);
			this.graphics.moveTo(_current.x, _current.y);
			this.graphics.lineTo(_start.x, _start.y);
			var count:uint = 0;
			for each (var data:LineData in _container) {
				++count;
				this.graphics.lineStyle(3, 0x000000, 1.0 - (0.05 * (_container.length - count)));
				this.graphics.moveTo(data.end.x, data.end.y);
				this.graphics.lineTo(data.start.x, data.start.y);
			}
		}
    }
}

class LineData
{
	public var start:flash.geom.Point;
	public var end:flash.geom.Point;
	
	public function LineData(s:flash.geom.Point, e:flash.geom.Point)
	{
		start = new flash.geom.Point(s.x, s.y);
		end = new flash.geom.Point(e.x, e.y);
	}
}