/**
 * Copyright royi ( http://wonderfl.net/user/royi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/74S8
 */

package {
    import flash.display.Graphics;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.display.Sprite;
    import com.bit101.components.*;
    
    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xefefef)]
    public class BasicTrigonometry extends Sprite {
        private var sw:int, sh:int;
        private var centerX:int, centerY:int;
        private var bgColor:uint = 0xefefef;
        private var lineColor:uint = 0xdfdfdf;
        private var triangle:Triangle = new Triangle();
        private var squares:Sprite = new Sprite();
        private var circles:Sprite = new Sprite();
        private var circleA:Circle = new Circle(0xff9999, "A");
        private var circleB:Circle = new Circle(0x99ff99, "B");
        private var circleC:Circle = new Circle(0x9999ff, "C");
        private var labels:Object = {};
        private var numLabels:int = 0;
        //private var debug:Label;
        private var mouseIsPressed:Boolean = false;
        public function BasicTrigonometry() {
            sw = stage.stageWidth, sh = stage.stageHeight;
            centerX = sw * .5, centerY = sh * .5;
            
            squares.x = centerX;
            squares.y = centerY;
            addChild(squares);
            
            triangle.x = centerX, triangle.y = centerY;
            addChild(triangle);
            
            circles.x = centerX, circles.y = centerY;
            addChild(circles);
            updateCircles();
            circles.addChild(circleA), circles.addChild(circleB), circles.addChild(circleC);
            
            // add labels
            labels.amouse = new Label(this, 0, 0, "x: 0 y: 0");
            labels.hypotenuse = new Label(this, 0, 0, "HYPOTENUSE AS3: Math.sqrt((C.x - A.x) * (C.x - A.x) + (C.y - A.y) * (C.y - A.y)) = " + triangle.hypotenuse);
            //labels.angleARad = new Label(this, 0, 0, "ANGLE A IN RADIANS: ");
            //labels.angleADeg = new Label(this, 0, 0, "ANGLE A IN DEGREES: ");
            
            for (var p:Object in labels) {
                labels[p].x = 3;
                labels[p].y = 3 + numLabels * 11;
                numLabels++;
            }
            
            draw();
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        private function updateCircles():void {
            circleA.x = triangle.a.x, circleA.y = triangle.a.y;
            circleB.x = triangle.b.x, circleB.y = triangle.b.y;
            circleC.x = triangle.c.x, circleC.y = triangle.c.y;
        }
        private function draw():void {
            var g:Graphics = graphics;
            g.clear();
            // background
            g.beginFill(bgColor);
            g.drawRect(0, 0, sw, sh);
            g.endFill();
            
            // x y lines
            g.lineStyle(0, lineColor);
            g.moveTo(centerX, 0);
            g.lineTo(centerX, sh);
            g.moveTo(0, centerY);
            g.lineTo(sw, centerY);
            
            // squares
            g = squares.graphics;
            g.clear();
            g.lineStyle(0, lineColor);
            // hypotenuse
            g.moveTo(0, 0);
            g.lineTo(-triangle.opposite, triangle.adjacent);
            g.lineTo(triangle.adjacent - triangle.opposite, triangle.opposite + triangle.adjacent);
            g.lineTo(triangle.adjacent, triangle.opposite);
            // opposite
            g.lineTo(triangle.adjacent + triangle.opposite, triangle.opposite);
            g.lineTo(triangle.adjacent + triangle.opposite, 0);
            g.lineTo(triangle.adjacent, 0);
            // adjacent
            g.lineTo(triangle.adjacent, -triangle.adjacent);
            g.lineTo(0, -triangle.adjacent);
            g.lineTo(0, 0);
        }
        private function onMouseDown(e:MouseEvent):void {
            mouseIsPressed = true;
            onMouseMove();
        }
        private function onMouseUp(e:MouseEvent):void {
            mouseIsPressed = false;
            labels.hypotenuse.text = "HYPOTENUSE AS3: Math.sqrt((C.x - A.x) * (C.x - A.x) + (C.y - A.y) * (C.y - A.y)) = " + (int(triangle.hypotenuse * 100)/100) + "...";
        }
        private function onMouseMove(e:MouseEvent = null):void {
            if (mouseIsPressed) {
                triangle.b.x = triangle.mouseX;
                triangle.c.x = triangle.mouseX;
                triangle.c.y = triangle.mouseY;
                triangle.draw();
                updateCircles();
                draw();
                labels.hypotenuse.text = "HYPOTENUSE AS3: Math.sqrt((" + triangle.adjacent + ") * (" + triangle.adjacent + ") + (" + triangle.opposite + ") * (" + triangle.opposite + ")) = " + triangle.hypotenuse;
            }
            labels.amouse.text = "x: " + triangle.mouseX + " y: " + triangle.mouseY;
        }
    }
}

import flash.geom.Point;
import flash.display.Sprite;
import com.bit101.components.*;

class Triangle extends Sprite {
    public var a:Point = new Point(0, 0),
               b:Point = new Point(150, 0),
               c:Point = new Point(150, 80);
    private var color:uint;
    
    public var adjacent:Number;
    public var opposite:Number;
    public var hypotenuse:Number;
    
    private var angleA:Number;
    private var angleC:Number;
    
    private var lblAdjacent:Label;
    private var lblOpposite:Label;
    private var lblHypotenuse:Label;
    private var lblAngleA:Label;
    private var lblAngleC:Label;
    
    public function Triangle(color:uint = 0x555555) {
        this.color = color;
        
        lblAdjacent = new Label(this, 0, 0, "adjacent");
        lblAdjacent.autoSize = true;
        lblOpposite = new Label(this, 0, 0, "opposite");
        lblOpposite.autoSize = true;
        lblOpposite.rotation = 90;
        lblHypotenuse = new Label(this, 0, 0, "hypotenuse");
        lblHypotenuse.autoSize = true;
        lblHypotenuse.textField.x = -(lblHypotenuse.width * .5) - 10;
        lblAngleA = new Label(this);
        lblAngleA.autoSize = true;
        lblAngleC = new Label(this);
        lblAngleC.autoSize = true;
        
        draw();
    }
    public function draw():void {
        graphics.clear();
        graphics.lineStyle(0, color);
        graphics.moveTo(a.x, a.y);
        graphics.lineTo(b.x, b.y);
        graphics.lineTo(c.x, c.y);
        graphics.lineTo(a.x, a.y);
        
        var cSign:Point = new Point();
        cSign.x = c.x < 0 ? -1 : 1;
        cSign.y = c.y < 0 ? -1 : 1;
        
        adjacent = c.x - a.x;
        opposite = c.y - a.y;
        hypotenuse = Math.sqrt((c.x - a.x) * (c.x - a.x) + (c.y - a.y) * (c.y - a.y));
        var angleARad:Number = Math.atan2(opposite, adjacent);
        var angleCRad:Number = Math.atan2(adjacent, opposite);
        angleA = Calc.deg(angleARad);
        angleC = Calc.deg(angleCRad);
        
        
        // right angle symbol
        graphics.moveTo(b.x, b.y + cSign.y * 10);
        graphics.lineTo(b.x + cSign.x * -10, b.y + cSign.y * 10);
        graphics.lineTo(b.x + cSign.x * -10, b.y);
        
        // labels
        lblAdjacent.text = "adjacent " + adjacent;
        lblAdjacent.draw();
        lblAdjacent.x = (b.x - lblAdjacent.width) * .5;
        lblAdjacent.y = b.y - (c.y < 0 ? 0 : lblAdjacent.height);
        
        lblOpposite.text = "opposite " + opposite;
        lblOpposite.draw();
        lblOpposite.x = b.x + (c.x < 0 ? 0 : lblOpposite.height);
        lblOpposite.y = (c.y - lblOpposite.width) * .5;
        
        lblHypotenuse.text = "hypotenuse " + int(hypotenuse);
        lblHypotenuse.rotation = angleA;
        lblHypotenuse.x = (adjacent) * .5;
        lblHypotenuse.y = (opposite) * .5;
        lblHypotenuse.scaleX = lblHypotenuse.scaleY = angleC < 0 ? -1 : 1;
        
        lblAngleA.text = "atan2(op, ad): " + (int(angleARad * 100)/100) + " (" + int(angleA) + "°)";
        lblAngleA.draw();
        lblAngleA.x = a.x - (c.x < 0 ? 0 : lblAngleA.width);
        lblAngleA.y = a.y - (c.y < 0 ? 0 : lblAngleA.height);
        
        lblAngleC.text = "atan2(ad, op): " + (int(angleCRad * 100)/100) + " (" + int(angleC) + "°)";
        lblAngleC.draw();
        lblAngleC.x = c.x - (c.x < 0 ? lblAngleC.width : 0);
        lblAngleC.y = c.y - (c.y < 0 ? lblAngleC.height : 0);
    }
}

import flash.display.Shape;

class Circle extends Sprite {
    public function Circle(color:uint = 0xff9999, text:String = "") {
        graphics.beginFill(color, .8);
        graphics.drawCircle(0, 0, 7);
        graphics.endFill();
        new Label(this, -4, -9, text);
    }
}

class Calc {
    public static function rad(degrees:Number):Number { return degrees * Math.PI / 180; }
    public static function deg(radians:Number):Number { return radians * 180 / Math.PI; }
}
