/**
 * Copyright mitien ( http://wonderfl.net/user/mitien )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/740P
 */

// forked from otherone's QuickBox2Dとテキストと、、
package 
{
    import flash.display.*;
    
    //import caurina.transitions.*;
    import com.actionsnippet.qbox.*;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import net.hires.debug.Stats;
    import com.bit101.components.InputText;
    import com.bit101.components.PushButton;
    
    [SWF(backgroundColor = 0x000000, width = 500, height = 500, frameRate = 50)]
    /*
    参考
    http://d.hatena.ne.jp/ActionScript/20080913/as3_layout_textfield    
    http://blog.alumican.net/2009/06/28_021753#qb2d_samples
    */
    
    public class Main extends MovieClip
    {
        //variables
        private var sim:QuickBox2D;
        private var contact:QuickContacts;
        private var boxList:Array=[];
        private var setTxt:String="";
        private var button:PushButton;
        private var input:InputText;
        
        //const
        private const SCALE:int = 30,stw:uint = stage.stageWidth,sth:uint = stage.stageHeight;
        
        
        public function Main():void
        {
            
            addChild(new Stats());
            
            input = new InputText(this, 0, 20, "Input text", onChange);
            input.width=200;
            input.x=stw-input.width-5;
            input.maxChars = 10;
            
            button = new PushButton(this,0 , input.y+input.height, "Click", onMouseClick);
            button.x=stw-button.width-5;

            // QuickBox2Dのインスタンス作成、引数で渡したMovieClip内で計算描画する
            sim = new QuickBox2D(this, {gravityX:0, gravityY:50});

            //デフォルトの設定
            sim.setDefault({fillColor:0x333333,lineAlpha:0,radius:1.5});

            //ステージ四方に壁をつくる。ステージのリサイズには対応できない;
            //sim.createStageWalls();
            
            //床の生成
            sim.addBox({x:stw/2/SCALE, y:sth/SCALE, width:stw/SCALE+5, height:2, density:0});
            
            //壁などの固定オブジェクト以外のオブジェクトをマウスでドラッグ可能にする。
            sim.mouseDrag();
            //シミュレーション開始。毎フレーム自動でオブジェクトを更新
            sim.start();
            
            setTxt = "ABCDEFGHIJKLMNOPQRSTUVXYZ";
            txtSet();
            setTxt = "Input text";
            
            /**/
            stage.addEventListener(Event.ENTER_FRAME,function(event){
            //trace(boxList.length) 
            
            for(var i:int=0;i<boxList.length;i++){
                //画面の外に出たら反対側に移動
                var _tmc:QuickObject=boxList[i];
                if(_tmc.x < -50/SCALE) _tmc.x = (stw+50)/SCALE;
                else if(_tmc.x > (stw+50)/SCALE) _tmc.x = -50/SCALE;
                }
            });
            
        }
        
        
        private function onMouseClick(event:MouseEvent):void
        {
            //trace("クリックされました");
            txtSet();
            input.text=setTxt = "";
        }
        


        private function onChange(event:Event):void
        {
            //trace(event.currentTarget); // [object InputText]
            //trace(event.currentTarget.text); // 入力欄の内容
            setTxt=event.currentTarget.text
        }

        //文字の設定
        private function txtSet():void
        {
            for (var i:int = 0; i < setTxt.length; i++)
            {
                //テキストのビットマップ化
                var bitmapTxt:Bitmap = BitmapClass.bitmapTxt(Math.random()*28+30,setTxt.substr(i,1));
                var mc:MovieClip = new MovieClip  ;
                mc.addChild(bitmapTxt);
                bitmapTxt.x =  -  bitmapTxt.width / 2;
                bitmapTxt.y =  -  bitmapTxt.height / 2;
                var _w:Number = Math.floor((1/30*mc.width)*10)/10;
                var _h:Number =  Math.floor((1/30*mc.height)*10)/10;
                putsInCase(mc,_w,_h);
                
            }
        }
        
        
        //四角形のオブジェクトにビットマップ化した文字を登録
        private function putsInCase(textMc:MovieClip,w:Number,h:Number):void
        {
            //四角形の描画
            var box:QuickObject =sim.addBox({width:w,height:h});//sim.addBox({isBullet:false,angle:0.5,skin:textMc});
            //isBullet:trueは、精密な衝突計算の有無、trueにすると慣性がつく
            
            //元から描かれているものを消す
            box.userData.graphics.clear();
            
            //画像を表示する
            box.userData.addChild(textMc);
            
            box.x=stw/2/SCALE
            boxList.push(box);
        }

    }
}


//テキストのビットマップ化
import flash.display.*;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
class BitmapClass extends Sprite{
        
       /* function BitmapClass()
        {
        }
        */
       static public function bitmapTxt(fontsize:int,srtxt:String):Bitmap
        {
            var tf:TextField = new TextField  ;
            var format = new TextFormat()  ;
            format.size = fontsize;//Math.random() * 20 + 28;
            
            //format.font = "ＭＳ ゴシック";        // フォント名
            format.color = Math.random() * 0xCCCCCC;// 文字の色

            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.antiAliasType = flash.text.AntiAliasType.ADVANCED;//AntiAliasType.NORMAL;// アンチエイリアスの種類
            tf.sharpness = 0;// 文字エッジのシャープネス
            // テキストの色
            //tf.thickness = 1;        // 文字エッジの太さ
            tf.background = true;            // 背景の塗りがあるか？
            tf.backgroundColor = 0xFFFFFF;        // 背景の色

            tf.defaultTextFormat = format;//フォーマットを反映
            tf.text = srtxt;

            //ビットマップ化
            var _bmd:BitmapData = new BitmapData(tf.width,tf.height,true,0x00ffffff);
            _bmd.draw(tf);
            var tfBitmap:Bitmap = new Bitmap(_bmd);
            return tfBitmap;
        }
}


