/**
 * Copyright nyamogera ( http://wonderfl.net/user/nyamogera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/73l5
 */

// forked from coppieee's 新技術と12人の英雄たち
// forked from checkmate's Checkmate Vol.6 Amatuer
/**
 * えー。ごめんなさい。
 * 最近はてぶに新技術のホットエントリー
 * （わかんない人は「水着 新技術」でググって）があったので、
 * これをCHECKMATE用に作ればいいんじゃね？と思ったのが発端。
 * 適当に作って、いざ画像を加工しようとして、その画像どうしようか考えた。
 * よし、twitterで募集しよう！←ここが間違い
 * 何故か12人もいいよ！っていう人が出てきて俺ビビる。
 * アイコンがアイコンなだけに予想以上にえっちぃ感じがでない。
 * で、完成？したのがこれ。
 * 
 * 最初に出るのは１割エッチ。６割イミフ。３割可愛い。ぐらいの比率。
 * 画像はランダムで、12人の中の一人のアイコンです。
 * 
 * 普通にloadから、画像を読み込んで、画面ポチポチ押して、
 * filter押せば、例の新技術の完成です。
 * 円の右はじドラックすれば大きさ返れます。
 * 
 * 何に時間かかったって、一番は12人に対して一つ一つ加工していったところ。
 * サンプルとして1つあればいいやと、twitterで募集したのが間違い。
 * だけど、せっかく許可もらったんだし全員分頑張ったよ！
 * 提供ありがとうございます！
 * いろいろひどい使い方してるので「俺はもっとセクシーだ」などの苦情あったら言ってね。
 * 
 * @author coppieee
 */
package 
{
	import flash.text.TextField;
	import flash.trace.Trace;
	import com.bit101.components.CheckBox;
	import com.bit101.components.PushButton;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.net.FileReference;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.utils.ByteArray;
	import flash.display.Graphics;
	import flash.utils.Dictionary;
	
	public class Main extends Sprite 
	{
		private static const
			COPPIEEE:String = "http://a3.twimg.com/profile_images/603697621/c7bf8bfa8e3045bac369bf2cb6e84afd6e860027-sushi.png"
		private static const URLS:Array = [COPPIEEE];
		private static function get circleMap():Dictionary {
			if (_circleMap) { return _circleMap }
			_circleMap = new Dictionary();
			_circleMap[COPPIEEE] = [new Circle(134.45,291,43),new Circle(267.9,335.95,70.4),new Circle(352.65,238.05,39),new Circle(258,90.3,79),new Circle(130.9,137.85,50),new Circle(198,229,40),new Circle(153,367,30),new Circle(382,35,38),new Circle(26,284,30)];
			return _circleMap;
		}
		private static var _circleMap:Dictionary;
		
		private static const
			CANVAS_WIDHT:Number = 400,
			CANVAS_HEIGHT:Number = 462;
		
		private var copyCircle:TextField;
		
		public function Main():void
		{
			dataContainer = new Sprite();
			addChild(dataContainer);
			
			background = new Sprite();
			var g:Graphics = background.graphics;
			g.beginFill(0xFFFFAA,0.1);
			g.drawRect(0, 0, 462, 462);
			g.endFill();
			addChild(background);
			
			var loadButton:PushButton = new PushButton(this, 0, 0, "load");
			loadButton.width = 62;
			//var saveButton:PushButton = new PushButton(this, 0, 20, "save");
			//saveButton.width = 62;
			loadButton.addEventListener(MouseEvent.CLICK, function(e:Event):void {
				var f:FileReference = new FileReference();
				f.addEventListener(Event.SELECT, function(e:Event):void {
					f.addEventListener(Event.COMPLETE, function(e:Event):void {
						loadFile(f.data);
					});
					f.load();
				});
				f.browse();
			});
			//saveButton.addEventListener(MouseEvent.CLICK, function(e:Event):void {
				//trace("[" +
					//circles.map(function(x:Circle, ...rest):String {
						//return x.toString()}).join(",") + "]");
			//});
			
			filterBox = new CheckBox(this, 0, 40, "filter");
			filterBox.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
				if (filterBox.selected)
				{
					data.mask = canvas;
				}else {
					data.mask = null;
				}
			});
			
			dataContainer.x = loadButton.width;
			circles = [];
			background.addEventListener(MouseEvent.CLICK, function(e:MouseEvent):void {
				var circle:Circle =  new Circle(mouseX, mouseY);
				canvas.addChild(circle);
				background.addEventListener(MouseEvent.MOUSE_UP, circle.onMouseUp);
				circles.push(circle);
			});
			canvas = new Sprite();
			addChild(canvas);
			var url:String = URLS[int(URLS.length*Math.random() )]
			loadImage(url);
			//loadImage(NANLOW);
			circles = circleMap[url];
			circles.forEach(function(x:Circle, ...rest):void {
				canvas.addChild(x);
				background.addEventListener(MouseEvent.MOUSE_UP, x.onMouseUp);
			});
			background.addEventListener(MouseEvent.MOUSE_UP, updateCircle);
			
			addEventListener(Event.COMPLETE, function(e:Event):void {
				filterBox.selected = true;
				data.mask = canvas;
				removeEventListener(Event.COMPLETE, arguments.callee);
			});
		
			copyCircle = new TextField();
			copyCircle.x = 0
			copyCircle.y = 445;
			copyCircle.width = 465;
			copyCircle.height = 20;
			copyCircle.text = "test";
			copyCircle.border = true;
			addChild(copyCircle);
			
			updateCircle();
		}
		
		private function updateCircle(event:MouseEvent = null) : void {
			var str:String = "";
			circles.forEach(function(x:Circle, ...rest):void {
				if(str != "" ) str += ",new Circle(";
				else str += "new Circle("
				str += x.x + ",";
				str += x.y + ",";
				str += x.radius + ")";
			});
			
			copyCircle.text  = str;
		}
		
		private var circles:Array;
		private var data:Bitmap;
		private var dataContainer:Sprite;
		private var canvas:Sprite;
		private var background:Sprite;
		private var filterBox:CheckBox;
		private function init():Loader {
			if (data != null) {
				data.mask = null;
				filterBox.selected = false;
				dataContainer.removeChild(data);
				data.bitmapData.dispose();
				circles.forEach(function(x:Circle, ...rest):void { 
					canvas.removeChild(x);
					background.removeEventListener(MouseEvent.MOUSE_UP, x.onMouseUp);
				} );
				circles = [];
			}
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void {
				data = Bitmap(loader.content);
				//if (data.width > CANVAS_WIDHT) {
					data.scaleY = data.scaleX =  CANVAS_WIDHT/data.width;
				//}else {
					
				//}
				//if (data.height > CANVAS_HEIGHT) {
					//data.scaleX = data.scaleY = CANVAS_HEIGHT / data.height;
					//
				//}
				dataContainer.addChild(data);
				dispatchEvent(new Event(Event.COMPLETE));
			});
			return loader;
		}
		private function loadFile(bytes:ByteArray):void {
			init().loadBytes(bytes);
		}
		private function loadImage(url:String ):void {
			init().load(new URLRequest(url), new LoaderContext(true));
		}
	}
}
import flash.display.DisplayObjectContainer;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.events.Event;
import flash.geom.Point;
class Circle extends Sprite {
	public function get color():uint { return _color; }
	public function set color(value:uint):void {
		_color = value;
		draw();
	}
	private var _color:uint = 0x55FFFF;
	public function get radius():Number { return _radius; }
	public function set radius(value:Number):void {
		_radius = value;
		draw();
	}
	private var _radius:Number;
	
	//public function onMouseUp(e:MouseEvent):void {
		//stopDrag();
	//}
	public var onMouseUp:Function;
	
	public function Circle(	x:Number = 0, y:Number = 0 ,radius_:Number = 30) {
		this.x = x;
		this.y = y;
		//this._radius = radius;
		_circleView = new Sprite();
		addChild(_circleView);
		
		
		_circleView.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void {
			startDrag();
		});
		_circleView.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void {
			stopDrag();
		});
		
		_scaleView = new Sprite();
		
		var sg:Graphics = _scaleView.graphics;
		sg.beginFill(0xFFCCCC);
		sg.drawRect( -5, -5, 5, 5);
		sg.endFill();
		_scaleView.y = +_scaleView.height / 2;
		addChild(_scaleView);
		
		
		var scaleOnEnterFrame :Function = function(e:Event):void {
			_scaleView.x = mouseX ;//+ _scaleView.width/2;
			radius = _scaleView.x ;//- _scaleView.width/2;
		}
		var scaling:Boolean = false;
		_scaleView.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void {
			if (!scaling) {
				addEventListener(Event.ENTER_FRAME, scaleOnEnterFrame);
			}
			scaling = true;
		});
		
		_scaleView.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void {
			if (scaling) {
				removeEventListener(Event.ENTER_FRAME, scaleOnEnterFrame);
			}
			scaling = false;
		});
		this.radius = radius_;
		_scaleView.x = radius ;//+_scaleView.width / 2;
		
		onMouseUp = function(e:MouseEvent):void {
			stopDrag();
			if (scaling) {
				removeEventListener(Event.ENTER_FRAME, scaleOnEnterFrame);
			}
			scaling = false;
		};
	}
	private var _circleView:Sprite;
	private var _scaleView:Sprite;
	private function draw():void {
		var g:Graphics = _circleView.graphics;
		g.clear();
		g.beginFill(color,0.5);
		g.drawCircle(0, 0, radius);
		g.endFill();
	}
	public override function toString():String {
		return "new Circle("+x+","+y+","+radius+")";
	}
}