/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/73Kp
 */

package
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    [ SWF( width=300, height=300, backgroundColor=0xFFFFFF, frameRate=60 ) ]
    public class TicTacToe extends Sprite
    {
        
        private var data:Vector.<int> = new Vector.<int>( 9, true );
        
        private var O:Boolean = true;
        
        public function TicTacToe()
        {
            init();
            stage.addEventListener( MouseEvent.MOUSE_DOWN, MOUSE_DOWN );
        }
        
        private function init():void
        {
            with( graphics )
            {
                clear();
                lineStyle( 1 );
                moveTo( 100, 0 );
                lineTo( 100, 300 );
                moveTo( 200, 0 );
                lineTo( 200, 300 );
                moveTo( 0, 100 );
                lineTo( 300, 100 );
                moveTo( 0, 200 );
                lineTo( 300, 200 );
                lineStyle( 20 );
            }
            for( var i:int=0; i<9; ++i )
            {
                data[ i ] = 0;
            }
        }
        
        private function MOUSE_DOWN( e:MouseEvent ):void
        {
            if( data.indexOf( 0 ) == -1 ) init();
            var index:int = int( mouseY/100 )*3 + int( mouseX/100 );
            if( !data[ index ] )
            {
                if( O )
                {
                    drawO( index );
                    O = false;
                    data[ index ] = 1;
                } else {
                    drawX( index );
                    O = true;
                    data[ index ] = 2;
                }
            }
        }
        
        private function positionX( index:int ):int
        {
            return ( index%3 )*100+50;
        }
        
        private function positionY( index:int ):int
        {
            return int( index/3 )*100+50;
        }
        
        private function drawO( index:int ):void
        {
            graphics.drawCircle( positionX( index ), positionY( index ), 30 );
        }
        
        private function drawX( index:int ):void
        {
            var positionX:int = positionX( index );
            var positionY:int = positionY( index );
            with( graphics )
            {
                moveTo( -25+positionX, -25+positionY );
                lineTo( 25+positionX, 25+positionY );
                moveTo( 25+positionX, -25+positionY );
                lineTo( -25+positionX, 25+positionY );
            }
        }
        
    }
}