/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/72bQ
 */

// forked from umhr's Camera 640*480
/*
 * Cameraクラス
 * http://help.adobe.com/ja_JP/AS3LCR/Flex_4.0/flash/media/Camera.html
 *
 * Videoクラス
 * http://help.adobe.com/ja_JP/AS3LCR/Flex_4.0/flash/media/Video.html
 * */
package {
    import com.bit101.components.PushButton;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.SimpleButton;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.media.Camera;
    import flash.media.Video;
    public class Main extends Sprite {
        private var _video:Video;
        private var _bitmap:Bitmap;
        public function Main() {
            var camera:Camera = Camera.getCamera();
            //カメラの存在を確認
            if (camera) {
                _bitmap = new Bitmap(new BitmapData(465,465));
                this.addChild(_bitmap);
                camera.setMode(640, 480, 15);
                _video = new Video(640,480);
                _video.attachCamera(camera);
                _video.width = 160;
                _video.height = 120;
                this.addChild(_video);
                new PushButton(this, 0, 120, "Snap", atSnap);
            } else {
                trace("カメラが見つかりませんでした。");
            }
        }
        private function atSnap(event:MouseEvent):void {
            _bitmap.bitmapData.draw(_video);
        }
    }
}
